/*
 * Created on 27-may-2005
 * @author co01556e
 */
package com.ejie.r01m.objects.searchengine.query;

import java.io.Serializable;


/**
 * Modela una familia que se establece como filtro al buscador
 */
public class R01MSearchedFamily extends R01MBaseSearchedTypoObj implements Serializable {
    private static final long serialVersionUID = 9109920524551104369L;
///////////////////////////////////////////////////////////////////////////////////////////
//CONSTRUCTORS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vaco
     */
    public R01MSearchedFamily() {
        super();
    }
    /**
     * Constructor en base al identificador
     * @param newOid Identificador
     */
    public R01MSearchedFamily(String newOid) {
        this();
        this.oid = newOid;
    }    
    /**
     * Constructor a partir del identificador y el nombre
     * @param newOid Identificador
     * @param newName Nombre
     */
    public R01MSearchedFamily(String newOid,String newName) {
        this(newOid);
        this.name = newName;
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////    
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#equalsTo(com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj)
     */
    public boolean equalsTo(R01MBaseSearchedObj other) {
        if (other instanceof R01MSearchedFamily) {
            R01MSearchedFamily otherFam = (R01MSearchedFamily)other;
            boolean eq = true;
            eq &= (this.oid != null && otherFam.oid != null && this.oid.equals(otherFam.oid));                     
            return eq;
        }
        return false;
    }      
}
