package com.ejie.r01m.objects.searchengine.query;

import java.io.Serializable;

import com.ejie.r01f.log.R01FLog;



/**
 * Repositiorio de datos que se incluye en una query como 
 * condicin de bsqueda
 */
public class R01MSearchedDataRepository extends R01MBaseSearchedStorageObj implements Serializable {
    private static final long serialVersionUID = -5701131633609126746L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Identificador del servidor que contiene al repositorio
     */
    public String serverOid;
    /**
     * Identificador del repositorio de datos
     */
    public String dataRepositoryOid;    
///////////////////////////////////////////////////////////////////////////////////////////
//	 CONSTRUCTORS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vaco
     */
	public R01MSearchedDataRepository() {
        super();
	}
    /**
     * Constructor a partir del servidor y el repositorio de datos
     * @param newServerOid Identificador del servidor
     * @param newDataRepositoryOid Identificador del repositorio de datos
     */
    public R01MSearchedDataRepository(String newServerOid,String newDataRepositoryOid) {
        this();
        this.serverOid = newServerOid;
        this.dataRepositoryOid = newDataRepositoryOid;
    }
    /**
     * Constructor a partir del identificador y el nombre
     * @param newServerOid identificador del servidor padre
     * @param newDataRepositoryOid Identificador
     * @param newName Nombre
     */
    public R01MSearchedDataRepository(String newServerOid,String newDataRepositoryOid,String newName) {
        this(newServerOid,newDataRepositoryOid);
        this.name = newName;
    } 
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#equalsTo(com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj)
     */
    public boolean equalsTo(R01MBaseSearchedObj other) {
        if (other instanceof R01MSearchedDataRepository) {
            R01MSearchedDataRepository otherDR = (R01MSearchedDataRepository)other;
            boolean eq = true;
            eq &= (this.serverOid != null && otherDR.serverOid != null && this.serverOid.equals(otherDR.serverOid));
            eq &= (this.dataRepositoryOid != null && otherDR.dataRepositoryOid != null && this.dataRepositoryOid.equals(otherDR.dataRepositoryOid));
            return eq;
        }
        return false;
    }     
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#composeDebugInfo()
     */
    public String composeDebugInfo() {
        return "serverOid=" + this.serverOid + " dataStoreOid=" + this.dataRepositoryOid;
    }
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#composeQueryString()
     */
    public String getKey() {
        return (this.serverOid + "." + this.dataRepositoryOid); 
    } 
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#fromKey(java.lang.String)
     */
    public void fromKey(String key) {
        if (key == null) {
            R01FLog.to("r01m.searchEngine").severe("La key del objeto de almacenamiento dataRepository NO es valida: ha de tener el formato serverOid.dataRepositoryOid");
            return;
        }
        // La clave de un dataRepository es serverOid.dataRepositoryOid
        String[] keySplitted = key.split("\\.");
        if (keySplitted.length != 2) {
            R01FLog.to("r01m.searchEngine").severe("La key del dataStore " + key + " NO es valida: ha de tener el formato serverOid.dataRepositoryOid");
        } else {
            this.serverOid = keySplitted[0];
            this.dataRepositoryOid = keySplitted[1];
        }
    }    
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedStorageObj#getStorageObjOid()
     */
    public String getStorageObjOid() {
        return this.getDataRepositoryOid();
    }  
///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * @return Returns the serverOid.
     */
    public String getServerOid() {
        return this.serverOid;
    }
    /**
     * @param theServerOid The serverOid to set.
     */
    public void setServerOid(String theServerOid) {
        this.serverOid = theServerOid;
    }  
    /**
     * @return Returns the dataRepositoryOid.
     */
    public String getDataRepositoryOid() {
        return this.dataRepositoryOid;
    }
    /**
     * @param theDataRepositoryOid The dataRepositoryOid to set.
     */
    public void setDataRepositoryOid(String theDataRepositoryOid) {
        this.dataRepositoryOid = theDataRepositoryOid;
    }    
}
