/*
 * Created on 27-may-2005
 * @author co01556e
 */
package com.ejie.r01m.objects.searchengine.query;

import java.io.Serializable;


/**
 * Modela el tipo de contenido que se establece como filtro en una query al buscador
 */
public class R01MSearchedContentType extends R01MBaseSearchedTypoObj implements Serializable {
    private static final long serialVersionUID = 2148539693534263883L;
///////////////////////////////////////////////////////////////////////////////////////////
//CONSTRUCTORS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vaco
     */
	public R01MSearchedContentType() {
	    super();
	}
    /**
     * Constructor en base al identificador
     * @param newOid Identificador
     */
    public R01MSearchedContentType(String newOid) {
        this();
        this.oid = newOid;
    }    
    /**
     * Constructor a partir del identificador y el nombre
     * @param newOid Identificador
     * @param newName Nombre
     */
    public R01MSearchedContentType(String newOid,String newName) {
        this(newOid);
        this.name = newName;
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////    
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#equalsTo(com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj)
     */
    public boolean equalsTo(R01MBaseSearchedObj other) {
        if (other instanceof R01MSearchedContentType) {
            R01MSearchedContentType otherCT = (R01MSearchedContentType)other;
            boolean eq = true;
            eq &= (this.oid != null && otherCT.oid != null && this.oid.equals(otherCT.oid));                     
            return eq;
        }
        return false;
    }      
}
