/*
 * Created on 27-may-2005
 * @author co01556e
 */
package com.ejie.r01m.objects.searchengine.query;

import java.io.Serializable;


/**
 * Modela un cluster que se establece como condicin en una query de bsqueda.
 */
public class R01MSearchedCluster extends R01MBaseSearchedTypoObj implements Serializable {
    private static final long serialVersionUID = -5613524142663354350L;    
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vaco
     */
    public R01MSearchedCluster() {
        super();
    }
    /**
     * Constructor en base al identificador
     * @param newOid Identificador
     */
    public R01MSearchedCluster(final String newOid) {
        this();
        this.oid = newOid;
    }     
    /**
     * Constructor a partir del identificador y el nombre
     * @param newOid Identificador
     * @param newName Nombre
     */
    public R01MSearchedCluster(final String newOid,final String newName) {
        this(newOid);
        this.name = newName;
    } 
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////    
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#equalsTo(com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj)
     */
    public boolean equalsTo(final R01MBaseSearchedObj other) {
        if (other instanceof R01MSearchedCluster) {
            R01MSearchedCluster otherCl = (R01MSearchedCluster)other;
            boolean eq = true;
            eq &= (this.oid != null && otherCl.oid != null && this.oid.equals(otherCl.oid));                     
            return eq;
        }
        return false;
    }     
}
