package com.ejie.r01m.objects.searchengine.query;

import java.io.Serializable;

import com.ejie.r01f.log.R01FLog;


/**
 * Area de actuacin que se incluye en una query como condicin
 * de bsqueda.
 */
public class R01MSearchedArea extends R01MBaseSearchedStorageObj implements Serializable {
    private static final long serialVersionUID = -7274728889394973359L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Identificador del servidor.
     */
    public String serverOid;
    /**
     * Identificador del repositorio de datos.
     */
    public String dataRepositoryOid;
    /**
     * Identificador del area.
     */
    public String areaOid;
//////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vaco
     */
	public R01MSearchedArea(){
        super();
	}
    /**
     * Constructor a partir de los identificadores de objeto
     * @param newServerOid Identificador del servidor
     * @param newDataStoreOid Identificador del dataStore
     * @param newAreaOid Identificador del Area
     */
    public R01MSearchedArea(final String newServerOid,
                            final String newDataStoreOid,
                            final String newAreaOid) {
        this();
        this.serverOid = newServerOid;
        this.dataRepositoryOid = newDataStoreOid;
        this.areaOid = newAreaOid;
    }
    /**
     * Constructor a partir del identificador y el nombre
     * @param newServerOid Identificador del servidor al que pertenece el area
     * @param newDataRepositoryOid Identificador del repositorio de datos al que pertenece el area
     * @param newAreaOid Identificador 
     * @param newName Nombre
     */
    public R01MSearchedArea(final String newServerOid,
                            final String newDataRepositoryOid,
                            final String newAreaOid,
                            final String newName) {
        this(newServerOid,newDataRepositoryOid,newAreaOid);
        this.name = newName;
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////  
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#equalsTo(com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj)
     */
    public boolean equalsTo(final R01MBaseSearchedObj other) {
        if (other instanceof R01MSearchedArea) {
            R01MSearchedArea otherArea = (R01MSearchedArea)other;
            boolean eq = true;
            eq &= (this.serverOid != null && otherArea.serverOid != null && this.serverOid.equals(otherArea.serverOid));
            eq &= (this.dataRepositoryOid != null && otherArea.dataRepositoryOid != null && this.dataRepositoryOid.equals(otherArea.dataRepositoryOid));
            eq &= (this.areaOid != null && otherArea.areaOid != null && this.areaOid.equals(otherArea.areaOid));
            return eq;
        }
        return false;
    }     
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#composeDebugInfo()
     */
    public String composeDebugInfo() {
        return "serverOid=" + this.serverOid + " dataStoreOid=" + this.dataRepositoryOid + " areaOid=" + this.areaOid;
    }   
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#composeQueryString()
     */
    public String getKey() {
        return (this.serverOid + "." + this.dataRepositoryOid + "." + this.areaOid); 
    }
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#fromKey(java.lang.String)
     */
    public void fromKey(final String key) {
        if (key == null) {
            R01FLog.to("r01m.searchEngine").severe("La key del objeto de almacenamiento area NO es valida: ha de tener el formato serverOid.dataRepositoryOid.areaOid");
            return;
        }
        // La clave de un area es serverOid.dataRepositoryOid.areaOid
        String[] keySplitted = key.split("\\.");
        if (keySplitted.length != 3) {
            R01FLog.to("r01m.searchEngine").severe("La key del area " + key + " NO es valida: ha de tener el formato serverOid.dataRepositoryOid.areaOid");
        } else {
            this.serverOid = keySplitted[0];
            this.dataRepositoryOid = keySplitted[1];
            this.areaOid = keySplitted[2];
        }
    }
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedStorageObj#getStorageObjOid()
     */
    public String getStorageObjOid() {
        return this.getAreaOid();
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * @return Returns the serverOid.
     */
    public String getServerOid() {
        return this.serverOid;
    }
    /**
     * @param theServerOid The serverOid to set.
     */
    public void setServerOid(final String theServerOid) {
        this.serverOid = theServerOid;
    }
    /**
     * @return Returns the dataRepositoryOid.
     */
    public String getDataRepositoryOid() {
        return this.dataRepositoryOid;
    }
    /**
     * @param theDataRepositoryOid The dataRepositoryOid to set.
     */
    public void setDataRepositoryOid(final String theDataRepositoryOid) {
        this.dataRepositoryOid = theDataRepositoryOid;
    } 
    /**
     * @return Returns the areaOid.
     */
    public String getAreaOid() {
        return this.areaOid;
    }
    /**
     * @param theAreaOid The areaOid to set.
     */
    public void setAreaOid(final String theAreaOid) {
        this.areaOid = theAreaOid;
    }     
}
