/*
 * Created on 27-may-2005
 * @author co01556e
 */
package com.ejie.r01m.objects.searchengine.query;

import java.io.Serializable;

import com.ejie.r01f.log.R01FLog;

/**
 */
public abstract class R01MBaseSearchedTypoObj extends R01MBaseSearchedObj implements Serializable {
    private static final long serialVersionUID = 8348058622267566172L;

///////////////////////////////////////////////////////////////////////////////////////////
//  MEMBERS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Identificador del tipo
     */
    public String oid;
    /**
     * Identificador numrico (utilizado en bsquedas para acelerar)
     */
    private int numericId = -1;

///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vaco
     */
    public R01MBaseSearchedTypoObj() {
        super();
    } 
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS AUXILIARES
///////////////////////////////////////////////////////////////////////////////////////////     
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#composeDebugInfo()
     */
    public String composeDebugInfo() {
        return "oid=" + this.getOid() + " name=" + this.getName(); 
    }  
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#composeQueryString()
     */
    public String getKey() {
        return this.getOid();
    }     
    /* (non-Javadoc)
     * @see com.ejie.r01m.objects.searchengine.query.R01MBaseSearchedObj#fromKey(java.lang.String)
     */
    public void fromKey(final String key) {
        if (key == null) {
            R01FLog.to("r01m.searchEngine").severe("La key del objeto de tipologa NO es valida: ha de tener el formato serverOid.dataRepositoryOid.areaOid");
            return;
        }
        // La clave de un objeto de tipologia es directamente el identificador del objeto
        this.oid = key;
    }    
///////////////////////////////////////////////////////////////////////////////////////////
//  GETTERS & SETTERS
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * @return Returns the oid.
     */
    public String getOid() {
        return this.oid;
    }
    /**
     * @param newOid The oid to set.
     */
    public void setOid(final String newOid) {
        this.oid = newOid;
    }
    /**
     * @return numericId
     */
    public int getNumericId() {
        return this.numericId;
    }
    /**
     * @param theNumericId
     */
    public void setNumericId(final int theNumericId) {
        this.numericId = theNumericId;
    }     
}
