/*
 * Created on 27-may-2005
 * @author co01556e
 */
package com.ejie.r01m.objects.searchengine.query;

import java.io.Serializable;

/**
 * Clase base para los objetos buscables
 */
public abstract class R01MBaseSearchedObj implements Serializable {
    private static final long serialVersionUID = 459930640857822279L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MEMBERS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Nombre del objeto en el idioma de la aplicacin.
     */
    public String name;
    /**
     * <pre>
     * Indica si una condicin de bsqueda viene de un filtro hecho en la guia
     * de navegacin y adjunta los detalles de la guia
     * Esta informacin puede ser utilizada para construir la query...
     * </pre>
     */
    public R01MSearchedGuideConditionDetails guideCondition;

///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vaco
     */
    public R01MBaseSearchedObj() {
        super();
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Devuelve <code>true</code> o <code>false</code> en funcin de si el objeto es igual a otro dado.
     * @param other el otro objeto dado
     * @return <code>true</code> si son iguales y <code>false</code> si no lo son.
     */
    public abstract boolean equalsTo(R01MBaseSearchedObj other);
    /**
     * Compone informacion de depuracin.
     * @return una cadena con informacin de depuracin.
     */
    public abstract String composeDebugInfo();   
///////////////////////////////////////////////////////////////////////////////////////////
//  GETTERS & SETTERS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Compone un identificador UNICO del objeto
     * @return un identificador nico compuesto a partir de los miembros del mismo
     */
    public abstract String getKey();
    /**
     * Carga el estado del objeto a partir del identificador UNICO
     * @param key el identificador nico del objeto
     */
    public abstract void fromKey(String key);
    /**
     * @return Returns the nameStr.
     */
    public String getName() {
        return this.name;
    }
    /**
     * @param theName The name to set.
     */
    public void setName(final String theName) {
        this.name = theName;
    }
    /**
     * @return Returns the guideCondition
     */
    public R01MSearchedGuideConditionDetails getGuideCondition() {
        return this.guideCondition;
    }
    /**
     * @param theGuideCondition
     */
    public void setGuideCondition(final R01MSearchedGuideConditionDetails theGuideCondition) {
        this.guideCondition = theGuideCondition;
    } 
}
