/*
 * Created on Feb 16, 2010
 *
 * @author co00390i - Israel Garcia
 * (c) 2005 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.indexer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * <pre>
 * Fichero para Open Data.
 * </pre>
 */
public class R01MRispDocument implements Serializable {

    private static final long serialVersionUID = -7562167727656252709L;
// /////////////////////////////////////////////////////////////////////////////////////////
// CONSTANTES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Archivo de tipo desconocido
     */
    public static final String TYPE_UNKNOWN = "unknown";
    /**
     * Archivo empaquetado en formato zip
     */
    public static final String TYPE_ZIP = "zip";
    /**
     * Archivo empaquetado en formato zip sin adjuntos
     */
    public static final String TYPE_THINZIP = "zipThin";
    /**
     * Archivo XML
     */
    public static final String TYPE_XML = "xml";
    /**
     * Archivo CSV
     */
    public static final String TYPE_CSV = "csv";
    /**
     * Archivo XLS
     */
    public static final String TYPE_XLS = "xls";
    /**
     * Archivo WMS
     */
    public static final String TYPE_WMS = "wms";
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Tipo de documento
     */
    private String type = TYPE_UNKNOWN;
    /**
     * Tamao en bytes del archivo
     */
    private String size = null;
    /**
     * Path relativo al contenido del fichero
     */
    private String contentRelativePath = null;

    /**
     * Unidades (nulo o vacio son bytes)
     */
    private String units = null;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vacio
     */
    public R01MRispDocument() {
        super();
    }
    /**
     * Constructor
     */
    public R01MRispDocument( final String newType,
                             final String newContentRelativePath,
                             final String newSize) {
        this(newType,newContentRelativePath,newSize,null);
    }
    public R01MRispDocument( final String newType,
                             final String newContentRelativePath,
                             final String newSize, 
                             final String newUnits) {
        this();
        this.type = newType;
        this.contentRelativePath = newContentRelativePath;
        this.size = newSize;
        this.units = newUnits;
    }


///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET: DOCUMENTO
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * @return the type
     */
    public String getType() {
        return this.type;
    }
    /**
     * @param theType The type to set.
     */
    public void setType(final String theType) {
        this.type = theType;
    }
    /**
     * @return the size
     */
    public String getSize() {
        return this.size;
    }
    /**
     * @param theSize The size to set.
     */
    public void setSize(final String theSize) {
        this.size = theSize;
    }
    /**
     * @return the contentRelativePath
     */
    public String getContentRelativePath() {
        return this.contentRelativePath;
    }
    /**
     * @param theContentRelativePath The contentRelativePath to set.
     */
    public void setContentRelativePath(final String theContentRelativePath) {
        this.contentRelativePath = theContentRelativePath;
    }
    /**
     * @return the units
     */
    public String getUnits() {
        return this.units;
    }
    /**
     * @param theUnits The units to set.
     */
    public void setUnits(final String theUnits) {
        this.units = theUnits;
    }
// /////////////////////////////////////////////////////////////////////////////////////////
// METODOS interfaz java.io.Serializable
///////////////////////////////////////////////////////////////////////////////////////////

    public String toString() {
        return type + ";" + contentRelativePath + "," + size;
    }
 // /////////////////////////////////////////////////////////////////////////////////////////
 // OTROS METODOS
 ///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Funcion que convierte un objeto R01MDatastoreMetadata en un objeto de tipo JSON
     * @return JSONObject
     */
    public JSONObject composeJSONObject() {
        JSONObject jObject = new JSONObject();
        try {
            jObject.put("tipo",this.getType());
            jObject.put("path",this.getContentRelativePath());
            jObject.put("tamanio",this.getSize());
            if(this.getUnits() == null) {
                jObject.put("unidades","");
            }else {
                jObject.put("unidades",this.getUnits());
            }
        } catch (JSONException ex) {
            ex.printStackTrace(System.out);
        }
        return jObject;
    }


    /**
     * @param theMap mapa de objetos R01MRispDocument
     * @return cadena con formato JSON
     */
    public static String mapObjectsToJsonString(final Map theMap) {
        JSONArray jArray = new JSONArray();
        if (theMap != null) {
            Map.Entry me;
            for(Iterator itObjects=theMap.entrySet().iterator();itObjects.hasNext();) {
                me = (Map.Entry)itObjects.next();
                jArray.put(((R01MRispDocument)me.getValue()).composeJSONObject());
            }
        }
        return jArray.toString();
    }

    /**
     * Transforma una cadena JSON a un mapa
     * @param jString la cadena
     * @return mapa de indice el valor del "tipo", y de valor el path,tamo y unidades separados por comas
     */
    public static Map jsonArrayToMap(String jString) {
        Map theMap = new HashMap();
        /*Comprobamos si el string tiene formato JSON, es decir empieza y acaba por '[' ']'*/
        if(!jString.substring(0,1).equals("[") || !jString.substring(jString.length()-1,jString.length()).equals("]")) {
            return null;
        }

        JSONArray jArray;
        try {
            jArray = new JSONArray(jString);
        } catch (JSONException ex1) {
            /*Puede darse el caso que venga de autonomy y venga sin comillas*/
            Pattern p1 = Pattern.compile("\\{([^\\{\\}]*)\\}");//Obtenemos los elementos entre '{' '}'
            Matcher m1 = p1.matcher(jString);
            jArray = new JSONArray();
            while (m1.find()) {
                String JObjectString = m1.group(0);
                Pattern p2 = Pattern.compile("([^:,\\{\\}]*):((?:[a-zA-Z]+:)?[^:,\\{\\}]*)");
                Matcher m2 = p2.matcher(JObjectString);

                JSONObject jObjectAutonomy = new JSONObject(); // NOPMD by co00390i on 29/03/10 15:14 No se puede quitar, se almacenan en un mapa !!!
                while (m2.find()) {
                    try {
                        jObjectAutonomy.put(m2.group(1).trim(),m2.group(2).trim());
                    } catch (JSONException ex) {
                        ex.printStackTrace(System.out);
                    }
                }
                jArray.put(jObjectAutonomy);
            }
        }

        try {
            if (jArray != null && jArray.length()>0) {
                JSONObject jObject;
                StringBuffer rispValue;
                for(int i=0; i<jArray.length(); i++) {
                    jObject = (JSONObject)jArray.get(i);

                    rispValue = new StringBuffer(); // NOPMD by co00390i on 29/03/10 15:11 OJO: este constructor NO SE PUEDE QUITAR
                    rispValue.append(jObject.getString("path"));
                    rispValue.append(',');
                    rispValue.append(jObject.getString("tamanio"));
                    rispValue.append(',');
                    rispValue.append(jObject.getString("unidades"));

                    theMap.put(jObject.getString("tipo"),rispValue);
                }
            }
        } catch (JSONException ex) {
            theMap = null;
            ex.printStackTrace(System.out);
        }
        return theMap;

    }
    

    /**
     * Funcion que apartir de un objeto JSONObject crea un objeto R01MRispDocument
     * @param jObject con formato {"tipo":"CSV","path":"http://www.euskadi.net","tamanio":"12354","unidades":"Kb"}
     */
    
    public void loadFromJson(final JSONObject jObject) {
        try {
            this.type = jObject.getString("tipo");
            this.contentRelativePath = jObject.getString("path");
            this.size = jObject.getString("tamanio");
            this.units = jObject.getString("unidades");
        } catch (JSONException ex) {
            ex.printStackTrace(System.out);
        }
    }

}
