/*
 * Created on 15-sep-2005
 * 
 * @author ie00165h - Alex Lara
 * (c) 2005 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.indexer;

import java.io.Serializable;
import java.util.Map;

/**
 * Objeto base de los datos a indexar en el buscador sobre un
 * objeto de tipologia: cluster/familia/tipo
 */
public class R01MIndexableTypoObject implements Serializable {
    private static final long serialVersionUID = -4926595535342342197L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Identificador del objeto de tipologia
     */
    private String oid;
    /**
     * Identificador numrico del objeto
     */
    private int numericId;
    /**
     * Nombre del objeto de tipologia en diferentes idiomas
     */
    private Map name;
    /**
     * Trminos por los que se puede buscar todos los contenidos
     * de una determinada tipologa
     */
    private Map searchTerms;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * Constructor vaco
     */
    public R01MIndexableTypoObject() {
        super();
    }
    /**
     * Constructor
     * @param newOid Identificador
     * @param newNumericId identificador numerico
     * @param newName Mapa indexado por idioma con los nombres
     * @param newSearchTerms terminos de bsqueda indexados por idioma
     */
    public R01MIndexableTypoObject( final String newOid,
                                    final int newNumericId,
                                    final Map newName,
                                    final Map newSearchTerms) {
        this();
        this.oid = newOid;
        this.name = newName;
        this.searchTerms = newSearchTerms;
        this.numericId = newNumericId;
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET
///////////////////////////////////////////////////////////////////////////////////////////        
    /**
     * @return Returns the name.
     */
    public Map getName() {
        return this.name;
    }
    /**
     * @param theName The name to set.
     */
    public void setName(final Map theName) {
        this.name = theName;
    }
    /**
     * @return Returns the searchTerms.
     */
    public Map getSearchTerms() {
        return this.searchTerms;
    } 
    /**
     * @param lang idioma
     * @return terminos para el idioma esopecificado
     */
    public String getSearchTerms(final String lang) {
        return (String)(this.searchTerms != null ? this.searchTerms.get(lang):null);
    }    
    /**
     * @param theSearchTerm The searchTerm to set.
     */
    public void setSearchTerms(final Map theSearchTerm) {
        this.searchTerms = theSearchTerm;
    } 
    /**
     * @return Returns the oid.
     */
    public String getOid() {
        return this.oid;
    }
    /**
     * @param theOid The oid to set.
     */
    public void setOid(final String theOid) {
        this.oid = theOid;
    }
    /**
     * @return numericId
     */
    public int getNumericId() {
        return this.numericId;
    }
    /**
     * @param theNumericId
     */
    public void setNumericId(final int theNumericId) {
        this.numericId = theNumericId;
    }
}
