/*
 * Created on Sep 15, 2005
 *
 * @author IE00165H - Alex Lara
 * (c) 2005 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.indexer;

import java.io.Serializable;

/**
 * Informacion de tipologa indexable por un buscador
 */
public class R01MIndexableTypoInfo implements Serializable {
    private static final long serialVersionUID = -1995284520858788983L;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES
///////////////////////////////////////////////////////////////////////////////////////////
    public static final long CLUSTER_BASE_NUMERICID = 1000000;
    public static final long FAMILY_BASE_NUMERICID = 10000;
    public static final long TYPE_BASE_NUMERICID = 1;

///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Identificador numrico de la tipologa que se compone de la siguiente forma:
     *      1000000*cluster.numericId + 100000*family.numericId + 10000*type.numericId
     */
    private long numericId = -1;
    /**
     * Tipificacin: Cluster
     */
    private R01MIndexableTypoObject cluster = null;
    /**
     * Tipificacin: Familia
     */
    private R01MIndexableTypoObject family = null;
    /**
     * Tipificacion: tipo
     */
    private R01MIndexableTypoObject type = null;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vaco
     */
    public R01MIndexableTypoInfo() {
        super();
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET: TIPOLOGIA
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * @return Returns the numericId
     */
    public long getNumericId() {
        return this.numericId;
    }
    /**
     * @param theNumericId
     */
    public void setNumericId(final long theNumericId) {
        this.numericId = theNumericId;
    }
    /**
     * Computa el identificador numrico de una tipologa
     * @param clusterNumericId identificador numrico del cluster
     * @param familyNumericId identificador numrico de la familia
     * @param typeNumericId identificador numrico del tipo
     */
    public void setNumericId( final int clusterNumericId,
                              final int familyNumericId,
                              final int typeNumericId) {
        long computedNumericId = CLUSTER_BASE_NUMERICID*clusterNumericId + FAMILY_BASE_NUMERICID*familyNumericId + TYPE_BASE_NUMERICID*typeNumericId;
        this.numericId = computedNumericId;
    }
     /**
      * @return Returns the cluster.
      */
     public R01MIndexableTypoObject getCluster() {
         return this.cluster;
     }
     /**
      * @param theCluster The cluster to set.
      */
     public void setCluster(final R01MIndexableTypoObject theCluster) {
         this.cluster = theCluster;
     }
     /**
      * @return Returns the family.
      */
     public R01MIndexableTypoObject getFamily() {
         return this.family;
     }
     /**
      * @param theFamily The family to set.
      */
     public void setFamily(final R01MIndexableTypoObject theFamily) {
         this.family = theFamily;
     }
     /**
      * @return Returns the type.
      */
     public R01MIndexableTypoObject getType() {
         return this.type;
     }
     /**
      * @param theType The type to set.
      */
     public void setType(final R01MIndexableTypoObject theType) {
         this.type = theType;
     }

     // /////////////////////////////////////////////////////////////////////////////////////////
    // METODOS
    ///////////////////////////////////////////////////////////////////////////////////////////
     /**
      * Obtiene un cdigo mnemotcnico concatenando cada uno de los objetos separados por el carcter "<i>:</i>".
      * @return cluster,familia y tipo.
      */
     public String composeMemoCode() {
         return this.cluster.getOid() + ":" + this.family.getOid() + ":" + this.type.getOid();
     }
}
