/*
 * Created on Sep 8, 2005
 * 
 * @author ie00165h - Alex Lara
 * (c) 2005 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.indexer;

import java.io.Serializable;
import java.util.List;

/**
 * Catalogacin de un contenido para ser indexada por el buscador
 */
public class R01MIndexableStructureCatalog implements Serializable {
    private static final long serialVersionUID = 1705566013296476268L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////        
    /**
     * Identificador de la etiqueta
     */
    private String labelOid;
    /**
     * Identificador numrico de la etiqueta
     */
    private String labelNumericId;
    /**
     * Identificador de la estructura
     */
    private String structureOid;
    /**
     * Rol que toma la etiqueta en la estructura
     */
    private String labelRoleInStructure;
    /**
     * Trminos de la etiqueta en diferentes idiomas
     * (lista de objetos R01MIndexableLabelTerm)
     */
    private List terms;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * Constructor vaco
     */
    public R01MIndexableStructureCatalog() {
        super();
    }
    /**
     * Constructor
     * @param newStructureOid
     * @param newLabelOid
     * @param newLabelRoleInStructure
     * @param newTerms
     */
    public R01MIndexableStructureCatalog( final String newStructureOid,
                                          final String newLabelOid,
                                          final String newLabelRoleInStructure,
                                          final List newTerms) {
        this.structureOid = newStructureOid;
        this.labelOid = newLabelOid;
        this.labelRoleInStructure = newLabelRoleInStructure;
        this.terms = newTerms;        
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * @return Returns the labelOid.
     */
    public String getLabelOid() {
        return this.labelOid;
    }
    /**
     * @param theLabelOid The labelOid to set.
     */
    public void setLabelOid(final String theLabelOid) {
        this.labelOid = theLabelOid;
    }
    /**
     * @return Returns the labelNumericId.
     */
    public String getLabelNumericId() {
        return this.labelNumericId;
    }
    /**
     * @param theLabelNumericId The labelNumericOid to set.
     */
    public void setLabelNumericId(final String theLabelNumericId) {
        this.labelNumericId = theLabelNumericId;
    }    
    /**
     * @return Returns the labelRoleInStructure.
     */
    public String getLabelRoleInStructure() {
        return this.labelRoleInStructure;
    }
    /**
     * @param theLabelRoleInStructure The labelRoleInStructure to set.
     */
    public void setLabelRoleInStructure(final String theLabelRoleInStructure) {
        this.labelRoleInStructure = theLabelRoleInStructure;
    }
    /**
     * @return Returns the structureOid.
     */
    public String getStructureOid() {
        return this.structureOid;
    }
    /**
     * @param theStructureOid The structureOid to set.
     */
    public void setStructureOid(final String theStructureOid) {
        this.structureOid = theStructureOid;
    }
    /**
     * @return Returns the terms (objetos R01MIndexableLabelTerm).
     */
    public List getTerms() {
        return this.terms;
    }
    /**
     * @param theTerms The terms to set (objetos R01MIndexableLabelTerm)
     */
    public void setTerms(final List theTerms) {
        this.terms = theTerms;
    }
    
}
