/*
 * Created on 15-sep-2005
 * 
 * @author ie00165h - Alex Lara
 * (c) 2005 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.indexer;

import java.io.Serializable;
import java.util.Map;

/**
 * Objeto base de los datos a indexar en el buscador sobre un
 * objeto de almacenamiento: servidor/dataStore/area/workArea
 */
public class R01MIndexableStorageObject implements Serializable {
    private static final long serialVersionUID = -2232968202041943975L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Identificador del objeto de almacenamiento
     */
    private String oid = null;
    /**
     * Nombre del objeto de almacenamiento en diferentes idiomas
     */
    private Map name = null;
    /**
     * Path en el gestor de contenidos del objeto
     */
    private String path = null;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * Constructor vaco
     */
    public R01MIndexableStorageObject() {
        super();
    }
    /**
     * Constructor
     * @param newOid Identificador
     * @param newPath path del objeto de almacenamiento
     * @param newName Mapa de nombres indexados por idioma
     */
    public R01MIndexableStorageObject(final String newOid,
                                      final String newPath,
                                      final Map newName) {
        this();
        this.oid = newOid;
        this.path = newPath;
        this.name = newName;
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET
///////////////////////////////////////////////////////////////////////////////////////////        
    /**
     * @return Returns the name.
     */
    public Map getName() {
        return this.name;
    }
    /**
     * @param theName The name to set.
     */
    public void setName(final Map theName) {
        this.name = theName;
    }
    /**
     * @return Returns the oid.
     */
    public String getOid() {
        return this.oid;
    }
    /**
     * @param theOid The oid to set.
     */
    public void setOid(final String theOid) {
        this.oid = theOid;
    }
    /**
     * @return path
     */
    public String getPath() {
        return this.path;
    }
    /**
     * @param thePath
     */
    public void setPath(final String thePath) {
        this.path = thePath;
    }
}
