/*
 * Created on Sep 15, 2005
 * 
 * @author IE00165H - Alex Lara
 * (c) 2005 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.indexer;

import java.io.Serializable;

/**
 * Informacin de almacenamiento indexable por un motor de 
 * bsqueda
 */
public class R01MIndexableStorageInfo implements Serializable {
    private static final long serialVersionUID = 5490903736431960038L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////    
//------- ALMACENAMIENTO
    /**
     * Localizacion del contenido: Servidor
     */
    private R01MIndexableStorageObject server = null;
    /**
     * Localizacion del contenido: DataStore
     */
    private R01MIndexableStorageObject dataStore = null;
    /**
     * Localizacion del contenido: Area
     */
    private R01MIndexableStorageObject area = null;
    /**
     * Localizacion del contenido: WorkArea
     */
    private R01MIndexableStorageObject workArea = null;   
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * Constructor vacio
     */
    public R01MIndexableStorageInfo() {
        super();
    }
    /**
     * Constructor en base a otro objeto
     * @param other
     */
    public R01MIndexableStorageInfo(final R01MIndexableStorageInfo other) {
        if (other.getServer() != null) {
            this.server = new R01MIndexableStorageObject(other.getServer().getOid(),other.getServer().getPath(),
                                                         other.getServer().getName());
        }
        if (other.getDataStore() != null) {
            this.dataStore = new R01MIndexableStorageObject(other.getDataStore().getOid(),other.getDataStore().getPath(),
                                                            other.getDataStore().getName());
        }
        if (other.getArea() != null) {
            this.area = new R01MIndexableStorageObject(other.getArea().getOid(),other.getArea().getPath(),
                                                       other.getArea().getName());
        }
        if (other.getWorkArea() != null) {
            this.workArea = new R01MIndexableStorageObject(other.getWorkArea().getOid(),other.getWorkArea().getPath(),
                                                           other.getWorkArea().getName());
        }
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET: ALMACENAMIENTO
////////////////////////////////////////////////////////////////////////////////////////// /
     /**
      * @return Returns the server.
      */
     public R01MIndexableStorageObject getServer() {
         return this.server;
     }
     /**
      * @param theServer The serverOid to set.
      */
     public void setServer(final R01MIndexableStorageObject theServer) {
         this.server = theServer;
     }
     /**
      * @return Returns the dataStore.
      */
     public R01MIndexableStorageObject getDataStore() {
         return this.dataStore;
     }
     /**
      * @param theDataStore The dataStore to set.
      */
     public void setDataStore(final R01MIndexableStorageObject theDataStore) {
         this.dataStore = theDataStore;
     }
     /**
      * @return Returns the area.
      */
     public R01MIndexableStorageObject getArea() {
         return this.area;
     }
     /**
      * @param theArea The area to set.
      */
     public void setArea(final R01MIndexableStorageObject theArea) {
         this.area = theArea;
     }
     /**
      * @return Returns the workArea.
      */
     public R01MIndexableStorageObject getWorkArea() {
         return this.workArea;
     }
     /**
      * @param theWorkArea The workArea to set.
      */
     public void setWorkArea(final R01MIndexableStorageObject theWorkArea) {
         this.workArea = theWorkArea;
     }    

}
