/*
 * Created on Sep 16, 2005
 * 
 * @author IE00165H - Alex Lara
 * (c) 2005 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.indexer;

import java.io.Serializable;
import java.util.Date;

/**
 * Informacin de publicacin indexable por un motor de bsqueda.
 */
public class R01MIndexablePublicationInfo implements Serializable {
    private static final long serialVersionUID = -2389071289573492584L;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Estado despublicado.
     */
    public static final int STATE_UNPUBLISHED = 0;
    /**
     * Estado publicado.
     */
    public static final int STATE_PUBLISHED = 1;
    /**
     * Estado despublicado con errores
     */
    public static final int STATE_FAILED_UNPUBLISHED = 2;
    /**
     * Estado publicado con errores
     */
    public static final int STATE_FAILED_PUBLISHED = 3;
    /**
     * Estado publicacin en ejecucin
     */
    public static final int STATE_PUBLISH_RUNNING = 4;
    /**
     * Estado despublicacin en ejecucin
     */
    public static final int STATE_UNPUBLISH_RUNNING = 5;
    /**
     * Literales asociados a los estados de publicacin.
     */
    public static final String[] PUBLICATION_STATE_LABELS = {"Despublicado","Publicado","Despublicado con errores",
    														 "Publicado con errores","Publicacin en ejecucin",
    														 "Despublicacion en ejecucin"};
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Identificador del contexto de publicacion
     */
    private String repositoryOid;
    /**
     * Identificador numrico del repositorio
     */
    private int repositoryNumericId;
    /**
     * Alias del repositorio de publicacin
     */
    private String repositoryAlias;
    /**
     * Estado de la publicacion 1:publicado / 0: despublicado
     */
    private int state;
    /**
     * Fecha de publicacin
     */
    private Date publishDate;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * Constructor vacio
     */
    public R01MIndexablePublicationInfo() {
        super();
    }
    /**
     * Constructor
     * @param newOidRepository Identificador del contexto de publicacion
     * @param newRepositoryNumericId identificador numerico del repositorio de publicacin
     * @param newRepositoryAlias alias del repositorio de publicacin
     * @param newState estado de la publicacion
     * @param newPublishDate Fecha de publicacion
     */
    public R01MIndexablePublicationInfo(final String newOidRepository,
                                        final int newRepositoryNumericId,
                                        final String newRepositoryAlias,
                                        final int newState,
                                        final Date newPublishDate) {
        this();
        this.repositoryOid = newOidRepository;
        this.repositoryNumericId = newRepositoryNumericId;
        this.repositoryAlias = newRepositoryAlias;
        this.state = newState;
        this.publishDate = newPublishDate;
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * @return Returns the oidRepository.
     */
    public String getRepositoryOid() {
        return this.repositoryOid;
    }
    /**
     * @param theOidRepository The oidRepository to set.
     */
    public void setRepositoryOid(final String theOidRepository) {
        this.repositoryOid = theOidRepository;
    }
    /**
     * @return repositoryNumericId
     */
    public int getRepositoryNumericId() {
        return this.repositoryNumericId;
    }
    /**
     * @param theId
     */
    public void setRepositoryNumericId(final int theId) {
        this.repositoryNumericId = theId;
    }
    /**
     * @return repositoryAlias
     */
    public String getRepositoryAlias() {
        return this.repositoryAlias;
    }
    /**
     * @param theRepositoryAlias
     */
    public void setRepositoryAlias(final String theRepositoryAlias) {
        this.repositoryAlias = theRepositoryAlias;
    }    
    /**
     * @return state
     */
    public int getState() {
        return this.state;
    }
    /**
     * @param theState
     */
    public void setState(final int theState) {
        this.state = theState;
    }    
    /**
     * @return Returns the publishDate.
     */
    public Date getPublishDate() {
        return this.publishDate;
    }
    /**
     * @param thePublishDate The publishDate to set.
     */
    public void setPublishDate(final Date thePublishDate) {
        this.publishDate = thePublishDate;
    }
}
