/*
 * Created on Sep 9, 2005
 *
 * @author ie00165h - Alex Lara
 * (c) 2005 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.indexer;

import java.io.Serializable;

/**
 * Presentacin de un resultado en portal
 */
public class R01MIndexablePresentationInPortal implements Serializable {
    private static final long serialVersionUID = 1204271379102710784L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Cdigo de portal
     */
    private String portal;
    /**
     * Nombre interno de la pagina
     */
    private String page;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vaco
     */
    public R01MIndexablePresentationInPortal() {
        super();
    }
    /**
     * Constructor a partir del portal y la pagina
     * @param newPortal codigo de portal
     * @param newPage nombre interno de la pagina
     */
    public R01MIndexablePresentationInPortal(final String newPortal,final String newPage) {
        this.portal = newPortal;
        this.page = newPage;
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Establece el portal donde presentar un resultado de bsqueda
     * @return el codigo de portal
     */
    public String getPortal() {
        return this.portal;
    }
    /**
     * Devuelve el portal donde presentar un resultado de bsqueda
     * @param thePortal el codigo de portal
     */
    public void setPortal(final String thePortal) {
        this.portal = thePortal;
    }
    /**
     * Devuelve la pgina de portal donde presentar un resultado de bsqueda
     * @return el nombre interno de la pgina
     */
    public String getPage() {
        return this.page;
    }
    /**
     * Establece el nombre interno de la pgina donde presentar un resultado
     * de bsqueda
     * @param thePage el nombre interno de la pgina
     */
    public void setPage(final String thePage) {
        this.page = thePage;
    }
}
