/*
 * Created on Jul 14, 2008
 *
 * @author IE00165H - Alex Lara
 * (c) 2008 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.indexer;

import java.io.Serializable;
import java.util.Map;

/**
 * Objeto indexable de una pgina de portal.
 * Se asimila a un objeto contenido para su indexacin
 */
public class R01MIndexablePortalPage extends R01MIndexableContent implements Serializable {
    private static final long serialVersionUID = 6185028450738325301L;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vacio
     */
    public R01MIndexablePortalPage() {
        super();
        this.setObjectType(R01MBaseIndexableObject.OBJECT_TYPE_PORTALPAGE);
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Devuelve el nombre interno de la pgina
     * @return el nombre interno de la pgina
     */
    public String getPageInternalName() {
        return this.getInternalName();
    }
    /**
     * Establece el nombre interno de la pgina
     * @param thePageInternalName el nombre interno de la pgina
     */
    public void setPageInternalName(final String thePageInternalName) {
        this.setInternalName(thePageInternalName);
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET OBJETOS DEPENDIENTES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * @return Returns the langPages: objetos R01MIndexablePortalLangPage
     */
    public Map getLangPages() {
        return this.getDocuments();
    }
    /**
     * @param theLangPages The documents to set: objetos R01MIndexablePortalLangPage
     */
    public void setLangPages(final Map theLangPages) {
        this.setDocuments(theLangPages);
    }
    /**
     * Devuelve un objeto indexable idiomtico de pgina cuyo id se pasa
     * @param langPageOid identificador del objeto indexable idiomtico de pgina
     * @return el objeto indexable idiomtico de pgina
     */
    public R01MIndexablePortalLangPage getLangPage(final String langPageOid) {
        return (R01MIndexablePortalLangPage)this.getDocument(langPageOid);
    }
}
