/*
 * Created on Jul 14, 2008
 *
 * @author IE00165H - Alex Lara
 * (c) 2008 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.indexer;

import java.io.Serializable;

/**
 * Objeto indexable de una pgina de portal en un lenguaje determinado
 * Se asimila a un objeto documento para su indexacin
 */
public class R01MIndexablePortalLangPage extends R01MIndexableDocument implements Serializable {
    private static final long serialVersionUID = 6185028450738325301L;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vacio
     */
    public R01MIndexablePortalLangPage() {
        super();
        this.setObjectType(R01MBaseIndexableObject.OBJECT_TYPE_PORTALLANGPAGE);
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Devuelve el identificador de pgina
     * @return el oid
     */
    public String getPageOid() {
        return this.getOid();
    }
    /**
     * Establece el identificador de pgina
     * @param thePageOid el identificador de pagina
     */
    public void setPageOid(final String thePageOid) {
        this.setOid(thePageOid);
    }
    /**
     * Devuelve el nombre interno de la pgina
     * @return el nombre interno de la pgina
     */
    public String getPageInternalName() {
        return this.getInternalName();
    }
    /**
     * Establece el nombre interno de la pgina
     * @param thePageInternalName el nombre interno de la pgina
     */
    public void setPageInternalName(final String thePageInternalName) {
        this.setInternalName(thePageInternalName);
    }
}
