/*
 * Created on Sep 15, 2005
 * 
 * @author IE00165H - Alex Lara
 * (c) 2005 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.indexer;

import java.io.Serializable;
import java.util.Map;

import com.ejie.r01m.utils.R01MConstants;

/**
 * <pre>
 * MetaDato indexable: Contiene toda la informacin del metadato para poder ser indexado
 * por un motor de bsqueda: nombre del metaDato y su descripcion en diferentes idomas,
 * valor y la descripcion del valor en diferentes idiomas en el caso de que el valor del
 * metaDato sea un cdigo....
 * </pre>
 */
public class R01MIndexableMetaData implements Serializable {
    private static final long serialVersionUID = -5447490051789266242L;    
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Tipo de metadato desconocido.
     */
    public static final String METADATA_UNKNOWN = "unknown";
    /**
     * Tipo de metadato cadena.
     */
    public static final String METADATA_STRING = "String";
    /**
     * Tipo de metadato entero 4 Bytes (32 bits).
     */
    public static final String METADATA_INTEGER = "Integer";
    /**
     * Tipo de metadato entero largo 8 Bytes (64 bits).
     */
    public static final String METADATA_LONG = "Long";
    /**
     * Tipo de metadato entero corto 2 Bytes (16 bits)
     */
    public static final String METADATA_SHORT = "Short";
    /**
     * Tipo de metadato en coma flotante 4 Bytes (32 bits).
     */
    public static final String METADATA_FLOAT = "Float";
    /**
     * Tipo de metadato en coma flotante 8 Bytes (64 bits).
     */
    public static final String METADATA_DOUBLE = "Double";
    /**
     * Tipo de metadato fecha.
     */
    public static final String METADATA_DATE = "Date";
    /**
     * Tipo de metadato lista.
     */
    public static final String METADATA_LIST = "List";
    /**
     * Tipo de metadato mapa.
     */
    public static final String METADATA_MAP = "Map";
    /**
     * Tipo de metadato etiqueta de catalogacin en ejes.
     */
    public static final String METADATA_STRUCTURECATALOG = "R01MStructureCatalog";
    /**
     * Tipo de metadato etiqueta de catalogacin geogrfica.
     */
    public static final String METADATA_GEOCATALOG = "R01MGeoCatalog";
    /**
     * Tipo de metadato informacin de publicacin de documento.
     */
    public static final String METADATA_DOCUMENTPUBLICATIONINFO = "R01MSearchResultItemPublicationInfo";

    /**
     * Expresin regular para machear el tipo de metaDato especificado en el fichero <i>searchMetaDataStorageConfig.xml</i>.
     */
    public static final String METADATA_TYPE_REGEX = "(" + METADATA_UNKNOWN + "|" +
                                                           METADATA_STRING + "|" +
                                                           METADATA_INTEGER + "|" +
                                                           METADATA_LONG + "|" +
                                                           METADATA_SHORT + "|" +
                                                           METADATA_FLOAT + "|" +
                                                           METADATA_DOUBLE + "|" +
                                                           METADATA_DATE + "|" +
                                                           METADATA_LIST + "|" +
                                                           METADATA_MAP + "|" +
                                                           METADATA_STRUCTURECATALOG + "|" +
                                                           METADATA_GEOCATALOG + "|" +
                                                           METADATA_DOCUMENTPUBLICATIONINFO + ")(?:\\((.+)\\))*";
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES: Widgets
///////////////////////////////////////////////////////////////////////////////////////////

    /**
     * Widget de tipo texto.
     */
    public static final String METADATA_WIDGET_TEXT = "text";
    /**
     * Widget de tipo fecha.
     */
    public static final String METADATA_WIDGET_CALENDAR = "date";
    /**
     * Widget de tipo lista.
     */
    public static final String METADATA_WIDGET_LIST = "list";
    /**
     * Widget de tipo lista mltiple.
     */
    public static final String METADATA_WIDGET_MULTIPLELIST = "multipleList";

///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES: Formatos de metadatos (expresiones regulares)
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Formato de metadato general.
     */
    public static final String FORMAT_GENERAL = "general";
    /**
     * Formato de metadato numrico.
     */
    public static final String FORMAT_NUMBER = "number";
    /**
     * Formato de metadato fecha.
     */
    public static final String FORMAT_DATE = "Date(^[)]*)";
    /**
     * Formato de metadato solo nombre fecha.
     */    
    public static final String FORMAT_SIMPLE_DATE = "Date.*";
    
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES: Tipos de operaciones con los metadatos
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Tipo de operacin con metadatos igualdad.
     */
    public static final String OPERATION_EQUALS = "EQ";
    /**
     * Tipo de operacin con metadatos desigualdad.
     */
    public static final String OPERATION_NOTEQUALS = "NEQ";
    /**
     * Tipo de operacin con metadatos like.
     */
    public static final String OPERATION_LIKE = "LIKE";
    /**
     * Tipo de operacin con metadatos menor que.
     */
    public static final String OPERATION_LESSTHAN = "LT";
    /**
     * Tipo de operacin con metadatos mayor que.
     */
    public static final String OPERATION_GREATHERTHAN = "GT";
    /**
     * Tipo de operacin con metadatos menor o igual que.
     */
    public static final String OPERATION_LESSTHAN_OR_EQUALS = "LTE";
    /**
     * Tipo de operacin con metadatos mayor o igual que.
     */
    public static final String OPERATION_GREATHERTHAN_OR_EQUALS = "GTE";
    /**
     * Tipo de operacin con metadatos entre.
     */
    public static final String OPERATION_BETWEEN = "BETWEEN";
    /**
     * Tipo de operacin con metadatos ltimo.
     */
    public static final String OPERATION_LAST = "LAST";
    /**
     * Tipo de operacin con metadatos siguiente.
     */
    public static final String OPERATION_NEXT = "NEXT";
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Identificador del metaDato.
     */
    private String metaDataOid;
    /**
     * Nombre del metaDato en diferentes idiomas
     */
    private Map metaDataName;
    /**
     * Tipo de metaDato
     */
    private String metaDataType = METADATA_STRING;   // Por defecto texto
    /**
     * Valor del metaDato
     */
    private String metaDataValue;
    /**
     * <pre>
     * En el caso de que el metaDato sea una lista o una lista mltiple
     * en el campo metaDataValue va el CODIGO, y en este campo (metaDataValueDescription)
     * va la descripcion en todos los idiomas correspondiente a dicho cdigo.
     * </pre>
     */
    private Map metaDataValueDescription;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * Constructor vacio 
     */
    public R01MIndexableMetaData() {
        super();
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS DE UTILIDAD
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Compone informacin de depuracin acerca del metadato
     */
    public String composeDebugInfo() {
        StringBuffer outStr = new StringBuffer();
        outStr.append(this.getMetaDataOid() == null ? "oid null" : this.getMetaDataOid());
        outStr.append(" (");outStr.append(this.getMetaDataType() == null ? "dataType null" : this.getMetaDataType());outStr.append(") ");
        outStr.append(this.getMetaDataName() == null ? "name null" : this.getMetaDataName().get(R01MConstants.DEFAULT_LANG));
        outStr.append('=');outStr.append(this.getMetaDataValue() == null ? "value null" : this.getMetaDataValue());
        
        return outStr.toString();
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * @return Returns the metaDataOid.
     */
    public String getMetaDataOid() {
        return this.metaDataOid;
    }
    /**
     * @param theMetaDataOid The metaDataOid to set.
     */
    public void setMetaDataOid(final String theMetaDataOid) {
        this.metaDataOid = theMetaDataOid;
    }
    /**
     * @return Returns the metaDataType.
     */
    public String getMetaDataType() {
        return this.metaDataType;
    }
    /**
     * @param theMetaDataType The metaDataType to set.
     */
    public void setMetaDataType(final String theMetaDataType) {
        this.metaDataType = theMetaDataType;
    }    
    /**
     * @return Returns the metaDataName.
     */
    public Map getMetaDataName() {
        return this.metaDataName;
    }
    /**
     * @param theMetaDataName The metaDataName to set.
     */
    public void setMetaDataName(final Map theMetaDataName) {
        this.metaDataName = theMetaDataName;
    }
    /**
     * @return Returns the metaDataValue.
     */
    public String getMetaDataValue() {
        return this.metaDataValue;
    }
    /**
     * @param theMetaDataValue The metaDataValue to set.
     */
    public void setMetaDataValue(final String theMetaDataValue) {
        this.metaDataValue = theMetaDataValue;
    }
    /**
     * @return Returns the metaDataValueDescription.
     */
    public Map getMetaDataValueDescription() {
        return this.metaDataValueDescription;
    }
    /**
     * @param theMetaDataValueDescription The metaDataValueDescription to set.
     */
    public void setMetaDataValueDescription(final Map theMetaDataValueDescription) {
        this.metaDataValueDescription = theMetaDataValueDescription;
    }
    

}