/*
 * Created on Sep 9, 2005
 * 
 * @author ie00165h - Alex Lara
 * (c) 2005 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.indexer;

import java.io.Serializable;

/**
 * Trmino correspondiente a una etiqueta de catalogacin.
 */
public class R01MIndexableLabelTerm implements Serializable {
    private static final long serialVersionUID = 1104260379322720724L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////        
    /**
     * El lenguaje del trmino
     */
    private String lang;
    /**
     * El texto del trmino
     */
    private String termText;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////        
    /**
     * Constructor vaco 
     */
    public R01MIndexableLabelTerm() {
        super();
    }
    /**
     * Constructor a partir del lenguaje y el texto del trmino
     * @param newLang El lenguaje
     * @param newTermText El texto del trmino
     */
    public R01MIndexableLabelTerm(final String newLang, final String newTermText) {
        this.lang = newLang;
        this.termText = newTermText;        
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * @return Returns the lang.
     */
    public String getLang() {
        return this.lang;
    }
    /**
     * @param theLang The lang to set.
     */
    public void setLang(final String theLang) {
        this.lang = theLang;
    }
    /**
     * @return Returns the termText.
     */
    public String getTermText() {
        return this.termText;
    }
    /**
     * @param theTermText The termText to set.
     */
    public void setTermText(final String theTermText) {
        this.termText = theTermText;
    }
    

}
