/*
 * Created on Sep 9, 2005
 * 
 * @author ie00165h - Alex Lara
 * (c) 2005 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.indexer;

import java.io.Serializable;
import java.util.List;

/**
 * Etiqueta de catalogacion geogrfica para ser indexada por el buscador
 */
public class R01MIndexableGeoCatalog implements Serializable {
    private static final long serialVersionUID = -6011390964924824096L;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES
///////////////////////////////////////////////////////////////////////////////////////////
    // Nombres de las estructuras de catalogacion geogrficas
    public static final String GEOSTRUCTURE_COUNTRIES = "countries";
    public static final String GEOSTRUCTURE_TERRITORIES = "territories";
    public static final String GEOSTRUCTURE_PROVINCES = "provinces";
    public static final String GEOSTRUCTURE_MUNICIPALITIES = "municipalities";
    public static final String GEOSTRUCTURE_CITIES = "cities";
    public static final String GEOSTRUCTURE_STREETS = "streets";
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////        
    /**
     * Identificador de la etiqueta
     */
    private String geoLabelOid;
    /**
     * Identificador de la estructura
     */
    private String geoStructureOid;
    /**
     * Trminos de la etiqueta en diferentes idiomas
     * (lista de objetos R01MIndexableLabelTerm)
     */
    private List terms;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * Constructor vacio
     */
    public R01MIndexableGeoCatalog() {
        super();
    }
    /**
     * Constructor
     * @param newGeoStructureOid
     * @param newGeoLableOid
     * @param newTerms
     */
    public R01MIndexableGeoCatalog( final String newGeoStructureOid,
                                    final String newGeoLableOid,
                                    final List newTerms) {
        this.geoStructureOid = newGeoStructureOid;
        this.geoLabelOid = newGeoLableOid;
        this.terms = newTerms;
    }
    
///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * @return Returns the geoLabelOid.
     */
    public String getGeoLabelOid() {
        return this.geoLabelOid;
    }
    /**
     * @param theGeoLabelOid The geoLabelOid to set.
     */
    public void setGeoLabelOid(final String theGeoLabelOid) {
        this.geoLabelOid = theGeoLabelOid;
    }
    /**
     * @return Returns the geoStructureOid.
     */
    public String getGeoStructureOid() {
        return this.geoStructureOid;
    }
    /**
     * @param theGeoStructureOid The geoStructureOid to set.
     */
    public void setGeoStructureOid(final String theGeoStructureOid) {
        this.geoStructureOid = theGeoStructureOid;
    }
    /**
     * @return Returns the terms.
     */
    public List getTerms() {
        return this.terms;
    }
    /**
     * @param theTerms The terms to set.
     */
    public void setTerms(final List theTerms) {
        this.terms = theTerms;
    }
}
