/*
 * Created on Sep 16, 2010
 *
 * @author co00390i - Israel Garcia
 * (c) 2005 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.indexer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.ejie.r01f.util.StringUtils;

/**
 * <pre>
 * Informacin de vinculaciones de documentos para indexar en el buscador.
 * Contiene toda la informacin relativa a:
 *  Documentos vinculados desde el documento.
 *  Documentos desde los cuales se vincula el documento.
 *  Documentos con un tag determinado vinculados desde el documento.
 *  Documentos con un tag determinado desde los cuales se vincula el documento actual.
 * </pre>
 */
public class R01MIndexableDocumentLinkedData implements Serializable {

    private static final long serialVersionUID = 2143930631498024317L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Estructura JSON con la informacin de vinculaciones.
     */
    private String linkedDocumentInfo = null;
    /**
     * Identificadores de los documentos vinculados desde el documento separados por comas.
     * Es decir, aquellas relaciones en las cuales este documento es el propietario de la relacin,
     * y se realizan contra otro documento.
     */
    private String allLinkedDocumentSrc = null;
    /**
     * Identificadores de los documentos que vinculan este documento separados por comas.
     * Es decir, aquellas relaciones en las cuales otro documento es el propietario de la relacin,
     * y se realizan contra este documento.
     */
    private String allLinkedDocumentDst = null;
    /**
     * Mapa de identificador el id del tag y de valor una cadena con la lista de identificadores
     * de los documentos vinculados desde el documento, separados por comas.
     * Es decir, aquellas relaciones en las cuales este documento es el propietario de la relacin,
     * y tienen el tag correspondiente y se realizan contra otro documento.
     */
    private Map linkedDocumentsByTagSrc = null;
    /**
     * Mapa de identificador el id del tag y de valor una cadena con la lista de identificadores
     * de los documentos que vinculan a este documento, separados por comas.
     * Es decir, aquellas relaciones en las cuales otro documento es el propietario de la relacin,
     * y tienen el tag correspondiente y se realizan contra este documento.
     */
    private Map linkedDocumentsByTagDst = null;
    
    /**
     * Mapa de identificador el id del tag y de valor el nmero de vinculaciones
     * Es decir, aquellas relaciones en las cuales este documento es el propietario de la relacin,
     * y tienen el tag correspondiente y se realizan contra otro documento.
     */
    private Map linkedSizeByTagSrc = null;

///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vacio
     */
    public R01MIndexableDocumentLinkedData() {
        super();
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET: DOCUMENTO
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * @return the linkedDocumentInfo
     */
    public String getLinkedDocumentInfo() {
        return this.linkedDocumentInfo;
    }

    /**
     * @param theLinkedDocumentInfo The linkedDocumentInfo to set.
     */
    public void setLinkedDocumentInfo(String theLinkedDocumentInfo) {
        this.linkedDocumentInfo = theLinkedDocumentInfo;
    }
    /**
     * @return the allLinkedDocumentSrc
     */
    public String getAllLinkedDocumentSrc() {
        return this.allLinkedDocumentSrc;
    }
    /**
     * @param theAllLinkedDocumentSrc The allLinkedDocumentSrc to set.
     */
    public void setAllLinkedDocumentSrc(String theAllLinkedDocumentSrc) {
        this.allLinkedDocumentSrc = theAllLinkedDocumentSrc;
    }
    /**
     * @return the allLinkedDocumentDst
     */
    public String getAllLinkedDocumentDst() {
        return this.allLinkedDocumentDst;
    }
    /**
     * @param theAllLinkedDocumentDst The allLinkedDocumentDst to set.
     */
    public void setAllLinkedDocumentDst(String theAllLinkedDocumentDst) {
        this.allLinkedDocumentDst = theAllLinkedDocumentDst;
    }
    /**
     * @return the linkedDocumentsByTagSrc
     */
    public Map getLinkedDocumentsByTagSrc() {
        return this.linkedDocumentsByTagSrc;
    }
    /**
     * @param theLinkedDocumentsByTagSrc The linkedDocumentsByTagSrc to set.
     */
    public void setLinkedDocumentsByTagSrc(Map theLinkedDocumentsByTagSrc) {
        this.linkedDocumentsByTagSrc = theLinkedDocumentsByTagSrc;
    }
    /**
     * @return the linkedDocumentsByTagDst
     */
    public Map getLinkedDocumentsByTagDst() {
        return this.linkedDocumentsByTagDst;
    }
    /**
     * @param theLinkedDocumentsByTagDst The linkedDocumentsByTagDst to set.
     */
    public void setLinkedDocumentsByTagDst(Map theLinkedDocumentsByTagDst) {
        this.linkedDocumentsByTagDst = theLinkedDocumentsByTagDst;
    }
    /**
     * @return the linkedSizeByTagSrc
     */
    public Map getLinkedSizeByTagSrc() {
        return this.linkedSizeByTagSrc;
    }
    /**
     * @param thelinkedSizeByTagSrc The linkedSizeByTagSrc to set.
     */
    public void setLinkedSizeByTagSrc(Map thelinkedSizeByTagSrc) {
        this.linkedSizeByTagSrc = thelinkedSizeByTagSrc;
    }

// /////////////////////////////////////////////////////////////////////////////////////////
// METODOS AUXILIARES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Obtiene una lista de los documentos vinculados desde el documento.
     * @return una lista de los documentos vinculados desde el documento,<code>null</code> si no existe ninguno.
     */
    public List getAllLinkedDocumentSrcAsList() {
        List returnData = null;
        if(!StringUtils.isEmptyString(this.allLinkedDocumentSrc)) {
            String[] documentOids = this.allLinkedDocumentSrc.split(",");
            returnData = new ArrayList();
            for(int i=0;i<documentOids.length;i++) {
                returnData.add(documentOids[i]);
            }
        }
        return returnData;
    }
    /**
     * Obtiene una lista de los documentos que vinculan este documento.
     * @return una lista de los documentos que vinculan este documento,<code>null</code> si no existe ninguno.
     */
    public List getAllLinkedDocumentDstAsList() {
        List returnData = null;
        if(!StringUtils.isEmptyString(this.allLinkedDocumentDst)) {
            String[] documentOids = this.allLinkedDocumentDst.split(",");
            returnData = new ArrayList();
            for(int i=0;i<documentOids.length;i++) {
                returnData.add(documentOids[i]);
            }
        }
        return returnData;
    }
}
