/*
 * Created on Sep 8, 2005
 *
 * @author ie00165h - Alex Lara
 * (c) 2005 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.indexer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * <pre>
 * Archivo de datos para indexar en el buscador: Contiene toda la informacin relativa al contenido, documento
 * y el propio archivo de datos (nombres, objetos padre, catalogaciones, almacenamiento, tipificacion, etc),
 * de forma que es indexable de forma autnoma.
 * </pre>
 */
public class R01MIndexableDataFile extends R01MBaseIndexableObject implements Serializable {
    private static final long serialVersionUID = 5995777244699967106L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS: DATAFILE
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Indica si el dataFile contiene metaDatos sobre el documento
     */
    private boolean metaDataContainer = false;
    /**
     * Indica si el dataFile es el dataFile principal del documento
     */
    private boolean mainDataFile = false;
    /**
     * Plantilla de captura utilizada
     */
    private String dataCaptureTemplate;
    /**
     * Path relativo al documento del fichero generado a partir del dataFile con
     * la plantilla por defecto
     */
    private String defaultTemplateGeneratedFileDocumentRelativePath;
    /**
     * Paths relativos de los ficheros de datos generados
     * indexados por el nombre de la plantilla de presentacin utilizada
     */
    private Map generatedFilesDocumentRelativePaths;
    /**
     * Path relativos al contenido de los ficheros de datos
     */
    private String publishedContentRelativePath;
    /**
     * MetaDatos: Objetos R01MIndexableMetaData
     */
    private Map metaData;

///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vacio
     */
    public R01MIndexableDataFile() {
        super();
        this.setObjectType(R01MBaseIndexableObject.OBJECT_TYPE_DATAFILE);
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET: DATAFILE
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * @return Returns the metaData: Objetos R01MIndexableMetaData
     */
    public Map getMetaData() {
        return this.metaData;
    }
    /**
     * @param theMetaData The metaData to set: Objetos R01MIndexableMetaData
     */
    public void setMetaData(final Map theMetaData) {
        this.metaData = theMetaData;
    }
    /**
     * Aade un nuevo metaDato
     * @param idxMetaData metaDato
     */
    public void addMetaData(final R01MIndexableMetaData idxMetaData) {
        if (this.metaData == null) { 
            this.metaData = new HashMap();
        }
        this.metaData.put(idxMetaData.getMetaDataOid(),idxMetaData);
    }
    /**
     * Obtiene un metaDato cuyo oid se pasa
     * @param metaDataOid identificador del metaDato
     * @return el metadato objeto {@link com.ejie.r01m.objects.searchengine.indexer.R01MIndexableMetaData}
     */
    public R01MIndexableMetaData getMetaData(final String metaDataOid) {
        return (R01MIndexableMetaData)(this.metaData == null ? null:this.metaData.get(metaDataOid));
    }
    /**
     * @return Returns the metaDataContainer
     */
    public boolean isMetaDataContainer() {
        return this.metaDataContainer;
    }
    /**
     * @param isMetaDataContainer
     */
    public void setMetaDataContainer(final boolean isMetaDataContainer) {
        this.metaDataContainer = isMetaDataContainer;
    }
    /**
     * @return Returns the mainDataFile
     */
    public boolean isMainDataFile() {
        return this.mainDataFile;
    }
    /**
     * @param theMainDataFile
     */
    public void setMainDataFile(final boolean theMainDataFile) {
        this.mainDataFile = theMainDataFile;
    }
    /**
     * @return Returns the dataCaptureTemplate
     */
    public String getDataCaptureTemplate() {
        return this.dataCaptureTemplate;
    }
    /**
     * @param theDataCaptureTemplate
     */
    public void setDataCaptureTemplate(final String theDataCaptureTemplate) {
        this.dataCaptureTemplate = theDataCaptureTemplate;
    }
    /**
     * @return Returns the defaultTemplateGeneratedFileDocumentRelativePath
     */
    public String getDefaultTemplateGeneratedFileDocumentRelativePath() {
        return this.defaultTemplateGeneratedFileDocumentRelativePath;
    }
    /**
     * @param theDefaultTemplateGeneratedFileDocumentRelativePath
     */
    public void setDefaultTemplateGeneratedFileDocumentRelativePath(final String theDefaultTemplateGeneratedFileDocumentRelativePath) {
        this.defaultTemplateGeneratedFileDocumentRelativePath = theDefaultTemplateGeneratedFileDocumentRelativePath;
    }
    /**
     * @return Returns the generatedFilesDocumentRelativePaths
     */
    public Map getGeneratedFilesDocumentRelativePaths() {
        return this.generatedFilesDocumentRelativePaths;
    }
    /**
     * @param theGeneratedFilesDocumentRelativePaths
     */
    public void setGeneratedFilesDocumentRelativePaths(final Map theGeneratedFilesDocumentRelativePaths) {
        this.generatedFilesDocumentRelativePaths = theGeneratedFilesDocumentRelativePaths;
    }
    /**
     * @return the publishedContentRelativePath
     */
    public String getPublishedContentRelativePath() {
        return this.publishedContentRelativePath;
    }
    /**
     * @param thePublishedContentRelativePath The publishedContentRelativePath to set.
     */
    public void setPublishedContentRelativePath(final String thePublishedContentRelativePath) {
        this.publishedContentRelativePath = thePublishedContentRelativePath;
    }
}
