/*
 * Created on Sep 8, 2005
 *
 * @author ie00165h - Alex Lara
 * (c) 2005 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.indexer;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;

/**
 * <pre>
 * Contenido para indexar en el buscador: Contiene toda la informacin relativa al contenido
 * (nombres, catalogaciones, almacenamiento, tipificacion, etc) de forma que es indexable de
 * forma autnoma.
 * </pre>
 */
public class R01MIndexableContent extends R01MBaseIndexableRootObject implements Serializable {
    private static final long serialVersionUID = -5241682553254050064L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////
//  ------- ESPECIFICOS DEL CONTENIDO
    /**
     * Boosting para potenciar los resultados de bsqueda
     */
    private int boosting = 1;
    /**
     * Datos de presentacin de portal en el que se ha de mostrar el contenido cuando se pincha en un resultado de bsqueda
     * (se puede especificar en la configuracin de la workArea y se toma en tiempo de indexacin)
     */
    private R01MIndexablePresentationInPortal presentationInPortal = null;
    /**
     * Fecha hasta la que el contenido es novedad
     */
    private Date newnessUntilDate = null;
    /**
     * Responsable del contenido
     */
    private String responsible = null;
    /**
     * Nombre SEO asociado al contenido.
     */
    private String portalDataContentSEOName = "";
    /**
     * Descripcion SEO asociada al contenido.
     */
    private String portalDataContentSEODescription = "";

//  ------- OBJETOS DEPENDIENTES
    /**
     * Lista de documentos del contenido: objetos R01MIndexableDocument
     */
    private Map documents = null;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vacio
     */
    public R01MIndexableContent() {
        super();
        this.setObjectType(R01MBaseIndexableObject.OBJECT_TYPE_CONTENT);
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET ESPECIFICOS DEL CONTENIDO
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Devuelve el boosting para potenciar el elemento en los
     * resultados de bsqueda
     * @return el boosting
     */
    public int getBoosting() {
        return this.boosting;
    }
    /**
     * Establece el boosting para potenciar el elemento en los
     * resultados de bsqueda
     * @param theBoosting un entero
     */
    public void setBoosting(final int theBoosting) {
        this.boosting = theBoosting;
    }
    /**
     * Devuelve los datos de presentacin de portal para mostrar el contenido cuando se pincha en un
     * resultado de bsqueda
     * (se puede especificar en la configuracin de la workArea y se toma en tiempo de indexacin)
     * @return el codigo de portal
     */
    public R01MIndexablePresentationInPortal getPresentationInPortal() {
        return this.presentationInPortal;
    }
    /**
     * Establece los datos de presentacion de portal para de mostrar el contenido cuando se pincha en un
     * resultado de bsqueda
     * (se puede especificar en la configuracin de la workArea y se toma en tiempo de indexacin)
     * @param thePresentationInPortal el codigo de portal
     */
    public void setPresentationInPortal(final R01MIndexablePresentationInPortal thePresentationInPortal) {
        this.presentationInPortal = thePresentationInPortal;
    }
    /**
     * @return Returns the responsible.
     */
    public String getResponsible() {
        return this.responsible;
    }
    /**
     * @param theResponsible The theResponsible to set.
     */
    public void setResponsible(final String theResponsible) {
        this.responsible = theResponsible;
    }
    /**
     * @return Returns the newnessUntilDate.
     */
    public Date getNewnessUntilDate() {
        return this.newnessUntilDate;
    }
    /**
     * @param theNewnessUntilDate The theNewnessUntilDate to set.
     */
    public void setNewnessUntilDate(final Date theNewnessUntilDate) {
        this.newnessUntilDate = theNewnessUntilDate;
    }
    /**
	 * @return the portalDataContentSEOName
	 */
	public String getPortalDataContentSEOName() {
		return this.portalDataContentSEOName;
	}
	/**
	 * @param thePortalDataContentSEOName The portalDataContentSEOName to set.
	 */
	public void setPortalDataContentSEOName(String thePortalDataContentSEOName) {
		this.portalDataContentSEOName = thePortalDataContentSEOName;
	}
	/**
	 * @return the portalDataContentSEODescription
	 */
	public String getPortalDataContentSEODescription() {
		return this.portalDataContentSEODescription;
	}
	/**
	 * @param thePortalDataContentSEODescription The portalDataContentSEODescription to set.
	 */
	public void setPortalDataContentSEODescription(String thePortalDataContentSEODescription) {
		this.portalDataContentSEODescription = thePortalDataContentSEODescription;
	}
///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET OBJETOS DEPENDIENTES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * @return Returns the documents: objetos R01MIndexableObjectResume
     */
    public Map getDocuments() {
        return this.documents;
    }
    /**
     * @param theDocuments The documents to set: objetos R01MIndexableObjectResume
     */
    public void setDocuments(final Map theDocuments) {
        this.documents = theDocuments;
    }
    /**
     * Devuelve un documento cuyo id se pasa
     * @param documentOid identificador del documento
     * @return el documento indexable
     */
    public R01MIndexableDocument getDocument(final String documentOid) {
        return this.documents == null ? null:(R01MIndexableDocument)this.documents.get(documentOid);
    }

}
