/*
 * Created on Sep 8, 2005 @author ie00165h - Alex Lara (c) 2005 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.searchengine.indexer;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * <pre>
 * Objeto base de un objeto complejo del modelo: aquel objeto que se almacena, tipifica y cataloga
 * Los objetos {@link R01MIndexableContent}  y {@link R01MIndexablePortalPage} heredan de este objeto
 * ya que se almacenan, tipifican y catalogan
 * </pre>
 */
public abstract class R01MBaseIndexableRootObject extends R01MBaseIndexableObject implements Serializable {
    private static final long serialVersionUID = -6645361140657761646L;
///////////////////////////////////////////////////////////////////////////////////////////
// CONSTANTES
///////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////
// MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////
//  ------- ALMACENAMIENTO y TIPIFICACION
    /**
     * Localizacion del contenido
     */
    private R01MIndexableStorageInfo storage;
    /**
     * Tipificacin
     */
    private R01MIndexableTypoInfo typo;
  //------- CATALOGACION
    /**
     * Etiquetas de Catalogacion (objetos R01MIndexableStructureCatalog)
     */
    private List structureCatalogs;
    /**
     * Cdigos de Catalogacion geogrfica (objetos R01MIndexableGeoCatalog)
     */
    private List geoCatalogs;
//////////////////////////////////////////////////////////////////////////////////////////
// CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vacio
     */
    public R01MBaseIndexableRootObject() {
        super();
        this.setObjectType(R01MBaseIndexableObject.OBJECT_TYPE_UNKNOWN);
    }
    /**
     * Constructor a partir del tipo de objeto y otros miembros
     * @param newObjType tipo de objeto (ver constantes en {@link R01MBaseIndexableObject})
     * @param newOid identificador del objeto
     * @param newName nombre del objeto
     * @param newInternalName nombre interno del objeto
     * @param newDescription descripcin del objeto
     * @param newEditURLs urls de edicin del objeto en los diferentes idiomas del interfaz de usuario
     * @param newContentRispDocumentsInfo paths a informacion Risp
     * @param newMetas metadatos indexados por el oid del metaDato
     * @param newKeywords palabras clave
     */
    public R01MBaseIndexableRootObject( final int newObjType, 
                                        final String newOid,
                                        final String newName, 
                                        final String newInternalName, 
                                        final String newDescription,
                                        final Map newEditURLs,
                                        final Map newContentRispDocumentsInfo,
                                        final Map newMetas,
                                        final String newKeywords) {
        super(newObjType,newOid,newName,newInternalName,newDescription,newEditURLs,newContentRispDocumentsInfo,newMetas,newKeywords);
    }

    ///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET: TIPOLOGIA y ALMACENAMIENTO
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * @return Returns the storage.
     */
    public R01MIndexableStorageInfo getStorage() {
        return this.storage;
    }
    /**
     * @param theStorage The storage to set.
     */
    public void setStorage(final R01MIndexableStorageInfo theStorage) {
        this.storage = theStorage;
    }
    /**
     * @return Returns the typo.
     */
    public R01MIndexableTypoInfo getTypo() {
        return this.typo;
    }
    /**
     * @param theTypo The typo to set.
     */
    public void setTypo(final R01MIndexableTypoInfo theTypo) {
        this.typo = theTypo;
    }
///////////////////////////////////////////////////////////////////////////////////////////
// GET & SET: CATALOGACION
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * @return Returns the geoCatalogs. (R01MIndexableGeoCatalog)
     */
    public List getGeoCatalogs() {
        return this.geoCatalogs;
    }
    /**
     * @param theGeoCatalogs The geoCatalogs to set. (R01MIndexableGeoCatalog)
     */
    public void setGeoCatalogs(final List theGeoCatalogs) {
        this.geoCatalogs = theGeoCatalogs;
    }
    /**
     * @return Returns the structureCatalogs (R01MIndexableStructureCatalog)
     */
    public List getStructureCatalogs() {
        return this.structureCatalogs;
    }
    /**
     * @param theStructureCatalogs The structureCatalogs to set (R01MIndexableStructureCatalog)
     */
    public void setStructureCatalogs(final List theStructureCatalogs) {
        this.structureCatalogs = theStructureCatalogs;
    }
}
