package com.ejie.r01m.objects.cataloguing.structures;

import java.io.Serializable;
/**
 * <pre>
 * Trminos de una etiqueta dependiendo del idioma.
 * La etiqueta puede tener varios trminos en cada idioma, uno de ellos se define como trmino Normalizado y 
 * los dems como sinnimos de este. 
 * El trmino normalizado es el utilizado habitualmente para referirse a una etiqueta.
 * Los sinnimos se utilizan solamente en las bsquedas de etiquetas.
 * </pre>
 */
public class R01MTerm implements Serializable {
    
    private static final long serialVersionUID = 383698137797385525L;
    
// /////////////////////////////////////////////////////////////////////////////////////////
// CONSTANTES
// /////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Tipo de trmino sinnimo
     */
    public static final char TERM_TYPE_SYNONYMOUS = 'N';
    /**
     * Tipo de trmino estndar
     */
    public static final char TERM_TYPE_STANDARIZED = 'S';    
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * Valor del trmino.
     */
    private String value = "";
    /**
     * El lenguaje en el que esta definido el trmino.
     */
    private String language = "";
    /**
     * Identificador de la etiqueta a la que pertenece el trmino.
     */
    private int labelId;
    /**
     * Tipo de trmino (Standard o Sinnimo).
     */
    private char type = TERM_TYPE_STANDARIZED;
    /**
     * Identificador del trmino en Base de Datos.
     */
    private int termId= 0;
///////////////////////////////////////////////////////////////////////////////////////////
//  TERMINO
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * Constructor vacio.
     */
	public R01MTerm() {
		super();
	}	
	/**
	 * Constructor.
	 * @param newValue valor del trmino.
	 * @param newLanguage idioma del trmino.
	 */
	public R01MTerm(String newValue,String newLanguage){
	    super();
		this.language = newLanguage;
		this.value = newValue;
	}
///////////////////////////////////////////////////////////////////////////////////////////
//  GET & SET
///////////////////////////////////////////////////////////////////////////////////////////        	
	/**
	 * El lenguaje en el que esta definido el trmino.
	 * @return Returns the language.
	 */
	public String getLanguage() {
		return this.language;
	}
	/**
	 * Establece el lenguaje en el que esta definido el trmino.
	 * @param theLanguage The language to set.
	 */
	public void setLanguage(String theLanguage) {
		this.language = theLanguage;
	}
	/**
	 * Valor del trmino.
	 * @return Returns the value.
	 */
	public String getValue() {
		return this.value;
	}
	/**
	 * Establece el valor del trmino.
	 * @param theValue The value to set.
	 */
	public void setValue(String theValue) {
		this.value = theValue;
	}
	/**
	 * Identificador de la etiqueta a la que pertenece el trmino.
	 * @return Returns the labelId.
	 */
	public int getLabelId() {
		return this.labelId;
	}
	/**
	 * Establece el identificador de la etiqueta a la que pertenece el trmino.
	 * @param theLabelId The labelId to set.
	 */
	public void setLabelId(int theLabelId) {
		this.labelId = theLabelId;
	}
	/**
	 * Identificador del trmino en Base de Datos.
	 * @return Returns the termId.
	 */
	public int getTermId() {
		return this.termId;
	}
	/**
	 * Establece el identificador del trmino en Base de Datos.
	 * @param theTermId The termId to set.
	 */
	public void setTermId(int theTermId) {
		this.termId = theTermId;
	}
	/**
	 * Tipo de trmino (Standard o Sinnimo).
	 * @return Returns the type.
	 */
	public char getType() {
		return this.type;
	}
	/**
	 * Establece el tipo de trmino (Standard o Sinnimo).
	 * @param theType The type to set.
	 */
	public void setType(char theType) {
		this.type = theType;
	}
	

}
