package com.ejie.r01m.objects.cataloguing.structures;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01m.objects.R01MPrintableInterface;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;
/**
 * Definicin de una estructura.
 */
public class R01MStructureDefinition implements Serializable,
                                                R01MPrintableInterface {

    private static final long serialVersionUID = -7722810419048309536L;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES
///////////////////////////////////////////////////////////////////////////////////////////
    public static final String WITHOUT_TERM = "**Sin t&eacute;rmino**";
    public final static String SALTO_LINEA = "\r\n";
	public final static String NULL_VALUE = "null";

// /////////////////////////////////////////////////////////////////////////////////////////
// CONSTANTES
// /////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Carcter no imprimible para indicar que no se establece valor.
     */
    public static final char STRUCTURE_EMPTY_CHAR = '\u0000';
    /**
     * Tipo de estructura eje de catalogacin
     */
    public static final char STRUCTURE_TYPE_AXIS = 'E';
    /**
     * Tipo de estructura gua de navegacin
     */
    public static final char STRUCTURE_TYPE_GUIDE = 'G';
    /**
     * Estructura habilitada
     */
    public static final char STRUCTURE_STATUS_ENABLED = 'H';
    /**
     * Estructura deshabilitada
     */
    public static final char STRUCTURE_STATUS_DISABLED = 'D';

///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Identificador de la estructura en base de datos
	 */
	private int structureId;
	/**
	 * GUID de la estructura
	 */
	private String structureGUID;
	/**
	 * Tipo de estructura (eje o gua de navegacin)
	 */
	private char structureType = STRUCTURE_TYPE_AXIS;
	/**
	 * Descripcin de la estructura.
	 */
	private String structureDescription = "";
	/**
     * Grupo de la estructura.
     */
    private String structureGroup = "";
	/**
	 * Mapa con los nombres de la estructura indexados por idioma.
	 */
	private Map structureNames = new HashMap();
	/**
	 * ID en base de datos de la bolsa a la que pertenece.
	 */
	private int bagId = -1;
	/**
	 * Estado de la estructura (habilitada o deshabilitada).
	 */
	private char structureState = STRUCTURE_STATUS_DISABLED;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vacio
     */
    public R01MStructureDefinition () {
       super();
       // Generar automaticamente un oid para la estructura
       try {
           this.structureGUID = R01MUtils.generateNewOid(R01MConstants.STRUCTURES_APPCODE);
       } catch (GUIDDispenserException guidDispEx) {
           guidDispEx.printStackTrace(System.out);
           this.structureGUID = null;
       }
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS GET Y SET
///////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * @return Returns the bagGUID.
	 */
	public int getBagId() {
		return this.bagId;
	}
	/**
	 * @param theBagId The bagGUID to set.
	 */
	public void setBagId(int theBagId) {
		this.bagId = theBagId;
	}
	/**
	 * @return Returns the structureDescription.
	 */
	public String getStructureDescription() {
		return this.structureDescription;
	}
	/**
	 * @param theStructureDescription The structureDescription to set.
	 */
	public void setStructureDescription(String theStructureDescription) {
		this.structureDescription = theStructureDescription;
	}
	/**
	 * @return Returns the structureGUID.
	 */
	public String getStructureGUID() {
		return this.structureGUID;
	}
	/**
	 * @param theStructureGUID The structureGUID to set.
	 */
	public void setStructureGUID(String theStructureGUID) {
		this.structureGUID = theStructureGUID;
	}
	/**
	 * @return Returns the structureNames.
	 */
	public Map getStructureNames() {
		return this.structureNames;
	}
	/**
	 * @param theStructureNames The structureNames to set.
	 */
	public void setStructureNames(Map theStructureNames) {
		this.structureNames = theStructureNames;
	}
	/**
	 * @return Returns the structureState.
	 */
	public char getStructureState() {
		return this.structureState;
	}
	/**
	 * @param theStructureState The structureState to set.
	 */
	public void setStructureState(char theStructureState) {
		this.structureState = theStructureState;
	}
	/**
	 * @return Returns the structureType.
	 */
	public char getStructureType() {
		return this.structureType;
	}
	/**
	 * @param theStructureType The structureType to set.
	 */
	public void setStructureType(char theStructureType) {
		this.structureType = theStructureType;
	}
	/**
	 * @return Returns the structureId.
	 */
	public int getStructureId() {
		return this.structureId;
	}
	/**
	 * @param theStructureId The structureId to set.
	 */
	public void setStructureId(int theStructureId) {
		this.structureId = theStructureId;
	}
	/**
     * Establece el nombre idiomtico de la estructura
     * @param name nombre de la estructura
     * @param languageCode idioma
	 */
	public void setName(String name, String languageCode){
		this.structureNames.put(languageCode,name);
	}
    /**
     * Mtodo que devuelve el nombre de la estructura en el idioma determinado.
     * @param languageCode el idioma
     * @return el nombre en caso de tenerlo, "<i>** sin trmino **</i>" en caso de no existir
     */
	public String getName(String languageCode){
        String name = WITHOUT_TERM;
        if (this.structureNames != null && !this.structureNames.isEmpty()) {
            if (this.structureNames.containsKey(languageCode)) {
                name = (String)this.structureNames.get(languageCode);
                if (name == null) name = WITHOUT_TERM;
            }
        }
		return name;
	}
    /**
     * @return the structureGroup
     */
    public String getStructureGroup() {
        return this.structureGroup;
    }
    /**
     * @param theStructureGroup The structureGroup to set.
     */
    public void setStructureGroup(String theStructureGroup) {
        this.structureGroup = theStructureGroup;
    }

////////////////////////////////////////////////////////////////////////////////////
//  DEBUG
////////////////////////////////////////////////////////////////////////////////// //
    /**
     * Devuelve una representacion en formato cadena del objeto
     * @param prefix prefijo a ser concatenado a todas las lneas
     * @return El resumen de la pagina
     *              Propiedades
     *              Areas Visuales
     */
    public StringBuffer debugInfo(String prefix) {
        String tabPrefix = prefix + "\t";
        StringBuffer sb = new StringBuffer(163);
        sb.append(SALTO_LINEA);
        sb.append(prefix);sb.append("======== R01MStructureDefinition  ========\r\n");
        sb.append(prefix);sb.append("\tBagId:");sb.append(this.getBagId());sb.append(SALTO_LINEA);
        sb.append(prefix);sb.append("\tStructureId:");sb.append(this.getStructureId());sb.append(SALTO_LINEA);
        sb.append(prefix);sb.append("\tStructureGUID:");sb.append(this.getStructureGUID() == null ? "null" : this.getStructureGUID());sb.append(SALTO_LINEA);
        sb.append(prefix);sb.append("\tgetStructureGroup:");sb.append(this.getStructureGroup() == null ? "null" : this.getStructureGroup());sb.append(SALTO_LINEA);
        sb.append(prefix);sb.append("\tStructureDescription:");sb.append(this.getStructureDescription() == null ? "null" : this.getStructureDescription());sb.append(SALTO_LINEA);
        sb.append(prefix);sb.append("\tStructureState:");sb.append(this.getStructureState());sb.append(SALTO_LINEA);
        sb.append(prefix);sb.append("\tgetStructureType:");sb.append(this.getStructureType());sb.append(SALTO_LINEA);

        // Nombre
        if (this.getStructureNames() != null && !this.getStructureNames().isEmpty()) {
            sb.append(prefix);sb.append("\tNames:\r\n");
            Map.Entry me = null;
            for (Iterator it = this.getStructureNames().entrySet().iterator(); it.hasNext(); ) {
                me = (Map.Entry)it.next();

                sb.append(tabPrefix);
                sb.append('\t');
                sb.append(me.getKey());
                sb.append('=');
                sb.append(me.getValue());
                sb.append(SALTO_LINEA);
            }
        }

        return sb;
    }

}
