package com.ejie.r01m.objects.cataloguing.structures;

import java.io.Serializable;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;

/**
 * Modela una relacin entre etiquetas de un eje de catalogacin.
 */
public class R01MRelation  implements Serializable {

    private static final long serialVersionUID = -515142853102618200L;
// /////////////////////////////////////////////////////////////////////////////////////////
// CONSTANTES
// /////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Cdigo para la relacin de similitud entre etiquetas.
     */
    public static final char RELATION_SIMILARITY_CODE = 'R';
    /**
     * Cdigo para la relacin de descendencia entre etiquetas o estructura-etiqueta.
     */
    public static final char RELATION_HIERARCHY_CODE = 'H';
////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////
    /**
     * Identificador nico de la relacin
     */
    private String relationGuid;
    /**
     * Identificador numrico de la etiqueta padre
     */
    private int labelId1;
    /**
     * Identificador numrico de la etiqueta hija
     */
    private int labelId2;
    /**
     * Id interno de la relacin
     */
    private int relationId;
    /**
     * Id interno de la etiqueta padre
     */
    private int relationParentId = 0;
    /**
     * Tipo de relacin,jerrquica (H) o similar (R)
     */
    private char relationType = RELATION_HIERARCHY_CODE;
    /**
     * Identificador numrico de la estructura donde se encuentra la relacin
     */
    private int structureId;
    /**
     * <pre>
     * Orden de la relacin con respecto al resto de relaciones al mismo nivel.
     * P.e.: Si existen tres etiquetas que cuelgan de una etiqueta padre, cada una tiene un orden.
     *  parentlabel
     *       |- label1 (el orden es 1)
     *       |-label2  (el orden es 2)
     *       |-label3  (el orden es 3)
     * </pre>
     */
    private int order;
    /**
     * Almacena el trmino de la etiqueta padre en el idioma solicitado desde el API
     */
    private String termInLanguage = "";
    /**
     * Indica si el hijo de la relacin tambin tiene hijos.
     */
    private boolean hasChildren = false;

////////////////////////////////////////////////////////////////////////////////////////
//	CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Constructor vacio
	 */
	public R01MRelation() {
		super();
		// Generar automaticamente un oid para la pgina
        try {
            this.relationGuid = R01MUtils.generateNewOid(R01MConstants.STRUCTURES_APPCODE);
        } catch (GUIDDispenserException guidDispEx) {
            guidDispEx.printStackTrace(System.out);
            this.relationGuid = null;
        }
	}
	/**
	 * Constructor en base a una relacin entre dos etiquetas.
	 * @param newLabelId1 identificador de etiqueta.
	 * @param newLabelId2 identificador de etiqueta.
	 * @param newRelationType tipo de relacin.
	 */
	public R01MRelation( int newLabelId1, int newLabelId2, char newRelationType) {
		this();
		this.labelId1 = newLabelId1;
		this.labelId2 = newLabelId2;
		this.relationType = newRelationType;
	}
	/**
	 * Constructor en base a una relacin entre dos etiquetas de una estructura indicando el orden.
     * @param newLabelId1 identificador de etiqueta.
     * @param newLabelId2 identificador de etiqueta.
     * @param newRelationType tipo de relacin.
	 * @param theStructureId identificador de la estructura.
	 * @param theOrder orden de la relacin.
	 */
	public R01MRelation( int newLabelId1, int newLabelId2, char newRelationType, int theStructureId, int theOrder) {
		this(newLabelId1,newLabelId2, newRelationType);
		this.structureId = theStructureId;
        this.order = theOrder;
	}

////////////////////////////////////////////////////////////////////////////////////////
//	GETTERS & SETTERS
///////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Obtiene el identificador nico de la relacin.
     * @return el identificador
     */
    public String getRelationGuid() {
        return this.relationGuid;
    }
    /**
     * Establece el identificador nico de la relacin.
     * @param theRelationGuid el identificador nico de la relacin.
     */
    public void setRelationGuid(String theRelationGuid) {
        this.relationGuid = theRelationGuid;
    }
	/**
	 * Obtiene el identificador de la etiqueta padre
	 * @return el identificador de la etiqueta padre
	 */
	public int getLabelId1() {
		return this.labelId1;
	}
	/**
	 * Establece el identificador de la etiqueta padre
	 * @param theLabelGuid1 el identificador de la etiqueta padre
	 */
	public void setLabelId1(int theLabelGuid1) {
		this.labelId1 = theLabelGuid1;
	}
	/**
     * Obtiene el identificador de la etiqueta hija
     * @return el identificador de la etiqueta hija
     */
	public int getLabelId2() {
		return this.labelId2;
	}
	/**
     * Establece el identificador de la etiqueta hija
     * @param theLabelGuid2 el identificador de la etiqueta hija
     */
	public void setLabelId2(int theLabelGuid2) {
		this.labelId2 = theLabelGuid2;
	}
	/**
	 * Obtiene el tipo de la relacin, jerrquica o similar
	 * @return el tipo de la relacin
	 */
	public char getRelationType() {
		return this.relationType;
	}
	/**
     * Establece el tipo de la relacin, jerrquica o similar
     * @param theRelationType el tipo de la relacin
     */
	public void setRelationType(char theRelationType) {
		this.relationType = theRelationType;
	}
	/**
	 * Obtiene el identificador de la estructura
	 * @return theStructureGuid el identificador de la estructura
	 */
	public int getStructureId() {
		return this.structureId;
	}
	/**
     * Establece el identificador de la estructura
     * @return el identificador de la estructura
     */
	public void setStructureId(int theStructureId) {
		this.structureId = theStructureId;
	}
    /**
     * Obtiene el orden de la etiqueta en el nodo
     * @return el orden de la etiqueta en el nodo
     */
    public int getOrder() {
        return this.order;
    }
    /**
     * Establece el orden de la etiqueta en el nodo
     * @param theOrder el orden de la etiqueta en el nodo.
     */
    public void setOrder(int theOrder) {
        this.order = theOrder;
    }
    /**
     * Obtiene el id interno de la relacin
     * @return el id interno de la relacin
     */
    public int getRelationId() {
        return this.relationId;
    }
    /**
     * Establece el id interno de la relacin
     * @param theRelationId el id interno de la relacin
     */
    public void setRelationId(int theRelationId) {
        this.relationId = theRelationId;
    }
    /**
     * Obtiene el id interno del padre de la relacin
     * @return el id interno del padre de la relacin
     */
    public int getRelationParentId() {
        return this.relationParentId;
    }
    /**
     * Establece el id interno del padre de la relacin
     * @param theRelationParentId el id interno del padre de la relacin
     */
    public void setRelationParentId(int theRelationParentId) {
        this.relationParentId = theRelationParentId;
    }

	/**
	 * @return the termInLanguage
	 */
	public String getTermInLanguage() {
		return this.termInLanguage;
	}

	/**
	 * @param theTermInLanguage The termInLanguage to set.
	 */
	public void setTermInLanguage(String theTermInLanguage) {
		this.termInLanguage = theTermInLanguage;
	}


	/**
	 * @return the hasChildren
	 */
	public boolean hasChildren() {
		return this.hasChildren;
	}

	/**
	 * @param theHasChildren The hasChildren to set.
	 */
	public void setHasChildren(boolean theHasChildren) {
		this.hasChildren = theHasChildren;
	}

}
