package com.ejie.r01m.objects.cataloguing.structures;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.ejie.r01m.utils.R01MConstants;

/**
 * Criterio de bsqueda de etiquetas
 */
public class R01MLabelSearchFilter implements Serializable {
	private static final long serialVersionUID = 5778116641398263126L;
//////////////////////////////////////////////////////////////////////////////////////
//  ATRIBUTOS
/////////////////////////////////////////////////////////////////////////////////////	
    /**
     * Lenguaje del filtro.
     */
	private String languageId = R01MConstants.DEFAULT_LANG;
    /**
     * Trmino de busqueda del filtro.
     */
	private String termText;
	/**
	 * Bolsas de catalogacin en las que buscar.
	 */
    private List bags = new ArrayList();
    /**
     * Estructuras de catalogacin en las que buscar.
     */
    private List structureOids = new ArrayList();    
    /**
     * Indica si buscar en bolsas deshabilitadas.
     */
    private boolean withDisabledStructures = true;
//////////////////////////////////////////////////////////////////////////////////////
//	CONSTRUCTORES
/////////////////////////////////////////////////////////////////////////////////////
	/**
	 * @param newLanguageId
	 */
	public R01MLabelSearchFilter(String newLanguageId) {
        this.languageId = newLanguageId;
	}	
	/**
	 * Constructor a partir del termino de busqueda por texto libre en los terminos y el lenguaje.
	 * @param newTermText termino de busqueda por texto libre en los terminos
	 * @param newLanguageId identificador del lenguaje
	 */
	public R01MLabelSearchFilter(String newTermText,String newLanguageId){
		this(newLanguageId);
		this.termText = newTermText;
	}	
	/**
	 * <pre>
     * Constructor a partir del termino de busqueda por texto libre en los terminos, el lenguaje
     * y las bolsas de etiquetas en las que buscar.
     * Adems se puede especificar si buscar o no en las estructuras deshabilitadas.
     * </pre>
     * @param newTermText termino de busqueda por texto libre en los terminos
     * @param newLanguageId identificador del lenguaje
	 * @param newBagOids identificador de las bolsas
	 * @param newWithDisabledStructures true si se quiere buscar en las bolsas deshabilitadas
	 */
	public R01MLabelSearchFilter(String newTermText,String newLanguageId,List newBagOids,boolean newWithDisabledStructures){
		this(newTermText,newLanguageId);
		this.bags = newBagOids;
		this.withDisabledStructures = newWithDisabledStructures;
	}
	
///////////////////////////////////////////////////////////////////////////////////////
//	GET && SET
//////////////////////////////////////////////////////////////////////////////////////	
	/**
	 * @return Returns the languageId.
	 */
	public String getLanguageId() {
		return this.languageId;
	}
	/**
	 * @param theLanguageId The languageId to set.
	 */
	public void setLanguageId(String theLanguageId) {
		this.languageId = theLanguageId;
	}
	/**
	 * @return Returns the termText.
	 */
	public String getTermText() {
		return this.termText;
	}
	/**
	 * @param theTermText The searchCriteria to set.
	 */
	public void setTermText(String theTermText) {
		this.termText = theTermText;
	}
	/**
	 * @return Returns the vBags.
	 */
	public List getBagOids() {
		return this.bags;
	}
	/**
	 * @param newBags The vBags to set.
	 */
	public void setBagOids(List newBags) {
		this.bags = newBags;
	}
    /**
     * @return the structureOids
     */
    public List getStructureOids() {
        return this.structureOids;
    }
    /**
     * @param theStructureOids The structures to set.
     */
    public void setStructureOids(List theStructureOids) {
        this.structureOids = theStructureOids;
    }	
	/**
	 * @return Returns the withDisabledStructures.
	 */
	public boolean isWithDisabledStructures() {
		return this.withDisabledStructures;
	}
	/**
	 * @param theWithDisabledStructures The withDisabledStructures to set.
	 */
	public void setWithDisabledStructures(boolean theWithDisabledStructures) {
		this.withDisabledStructures = theWithDisabledStructures;
	}
	
	/**
     * @return the bags
     */
    public List getBags() {
        return this.bags;
    }
    /**
     * @param theBags The bags to set.
     */
    public void setBags(List theBags) {
        this.bags = theBags;
    }      

}
