package com.ejie.r01m.objects.cataloguing.structures;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MUtils;


/**
 * Objeto de definicin de una bolsa de catalogacin.<br>
 * Una Bolsa es una agrupacin de Etiquetas de catalogacin y de relaciones entre las mismas.
 */
public class R01MBag implements Serializable {
    private static final long serialVersionUID = -175346332137931316L;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTANTES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Literal de etiqueta sin trmino.
     */
    public static final String WITHOUT_TERM = "**Sin t&eacute;rmino**";
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Identificador numrico de la bolsa.
     */
    private int bagId;
    /**
     * Identificador del grupo de bolsa de catalogacin
     */
    private String groupOid;
    /**
     * Descripcin de la bolsa.
     */
    private String bagDescription = "";
    /**
     * GUID de la bolsa.
     */
    private String bagGUID;
    /**
     * Mapa de nombres de la bolsa por idiomas.
     */
    private Map bagNames= new Hashtable();
    /**
     * Lista de las estructuras pertenecientes a una bolsa. Solo contendr los GUID.
     */
    private List belongStuctures;

    /**
     * GUID de la bolsa en XLNETS.
     */
    private String bagXlnetsUID = "";
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vacio
     */
	public R01MBag() {
		super();
		// Generar automaticamente un oid para la bolsa
        try {
            this.bagGUID = R01MUtils.generateNewOid(R01MConstants.STRUCTURES_APPCODE);
        } catch (GUIDDispenserException guidDispEx) {
            guidDispEx.printStackTrace(System.out);
            this.bagGUID = null;
        }
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS GET/SET
///////////////////////////////////////////////////////////////////////////////////////////

	/**
	 * Descripcin de la bolsa.
	 * @return Returns the bagDescription.
	 */
	public String getBagDescription() {
		return this.bagDescription;
	}
	/**
	 * Establece la descripcin de la bolsa.
	 * @param theBagDescription The bagDescription to set.
	 */
	public void setBagDescription(String theBagDescription) {
		this.bagDescription = theBagDescription;
	}
	/**
	 * GUID de la bolsa.
	 * @return Returns the bagGUID.
	 */
	public String getBagGUID() {
		return this.bagGUID;
	}
	/**
	 * Establece el GUID de la bolsa.
	 * @param theBagGUID The bagGUID to set.
	 */
	public void setBagGUID(String theBagGUID) {
		this.bagGUID = theBagGUID;
	}
	/**
	 * Nombres idiomticos de la bolsa.
	 * @return Returns the bagNames.
	 */
	public Map getBagNames() {
		return this.bagNames;
	}
	
	 /**
     * Estructuras  pertenecientes a la bolsa
     * @return Returns the belongStructures.
     */
    public List getBelongStructures() {
        return this.belongStuctures;
    }
    
    /**
     * Establece las estructuras pertenecientes a una bolsa
     * @param theBelongStructures The theBelongStructures to set.
     */
    public void setBelongStructures(List theBelongStructures) {
        this.belongStuctures = theBelongStructures;
    }
	/**
	 * Establece los nombres idiomticos de la bolsa.
	 * @param theBagNames The bagNames to set.
	 */
	public void setBagNames(Map theBagNames) {
		this.bagNames = theBagNames;
	}
	/**
	 * GUID de la bolsa en XLNETS.
	 * @return Returns the bagXlnetsUID.
	 */
	public String getBagXlnetsUID() {
		return this.bagXlnetsUID;
	}

    /**
     * Establece el GUID de la bolsa en XLNETS.
	 * @param theBagXlnetsUID The bagXlnetsUID to set.
	 */
	public void setBagXlnetsUID(String theBagXlnetsUID) {
		this.bagXlnetsUID = theBagXlnetsUID;
	}
	/**
     * Establece el nombre idiomtico de la bolsa
     * @param name nombre de la bolsa
     * @param languageCode identificador del idioma
	 */
	public void setName(String name, String languageCode){
		this.bagNames.put(languageCode,name);
	}

	/**
	 * Obtiene el nombre de la bolsa en un idioma
	 * @param languageCode codigo del lenguaje
	 * @return el nombre de la bolsa
	 */
	public String getName(String languageCode) {
        String name = WITHOUT_TERM;
        if (this.bagNames!= null && !this.bagNames.isEmpty() && this.bagNames.containsKey(languageCode)) {
            return (String)this.bagNames.get(languageCode);
        }
        return name;
	}
	/**
	 * Identificador numrico de la bolsa.
	 * @return Returns the bagId.
	 */
	public int getBagId() {
		return this.bagId;
	}
	/**
	 * Establece el identificador numrico de la bolsa.
	 * @param theBagId The bagId to set.
	 */
	public void setBagId(int theBagId) {
		this.bagId = theBagId;
	}
    /**
     * Devuelve el grupo de bolsas a la que pertenece la bolsa
     * @return identificador del grupo de bolsas
     */
    public String getGroupOid() {
        return this.groupOid;
    }
    /**
     * Establece el grupo de bolsas a la que pertenece la bolsa
     * @param theGroupOid identificador del grupo de bolsas
     */
    public void setGroupOid(String theGroupOid) {
        this.groupOid = theGroupOid;
    }

}
