/*
 * Created on Jul 21, 2005
 *
 * @author ie00165h - Alex Lara
 * (c) 2005 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.objects.cataloguing;
import java.io.Serializable;

import com.ejie.r01m.objects.R01MPrintableInterface;

/**
 * <pre>
 * Catalogacin en una estructura (eje) junto las etiquetas padres.
 
 */
public class R01MStructureCatalogPairSelected implements R01MPrintableInterface,Serializable {

    private static final long serialVersionUID = 7000100772864366032L;
    ///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Estructura de la catalogacin.
     */
    public R01MStructureCatalog structureCatalog;
    /**
     * Identificador a <code>true</code> indica que se deben catalogar tambin todas las etiquetas padre del eje.
     */
    boolean selectParentLabels=false; 
    
    

    ///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Constructor vaco
     */
    public R01MStructureCatalogPairSelected() {
        super();
    }
    /**
     * Constructor a partir de la estructura de catalogacin y las etiquetas padres a seleccionar
     * @param newStructureCatalog Estructura de la catalogacin
     * @param newSelectParentLabels Identificador de las etiquetas padres a selecconar    
     */
    public R01MStructureCatalogPairSelected(R01MStructureCatalog newStructureCatalog,boolean newSelectParentLabels) {
        this.structureCatalog = newStructureCatalog;
        this.selectParentLabels = newSelectParentLabels;
        
    
    }
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////
    
    


    /**
     * @return the selectParentLabels
     */
    public boolean isSelectParentLabels() {
        return this.selectParentLabels;
    }
    
    /**
     * @param newSelectParentLabels The selectParentLabels to set.
     */
    public void setSelectParentLabels(boolean newSelectParentLabels) {
        this.selectParentLabels = newSelectParentLabels;
    }   
/**
     * @return the structureCatalog
     */
    public R01MStructureCatalog getStructureCatalog() {
        return this.structureCatalog;
    }
    /**
     * @param structureCatalog The structureCatalog to set.
     */
    public void setStructureCatalog(R01MStructureCatalog structureCatalog) {
        this.structureCatalog = structureCatalog;
    }
        ////////////////////////////////////////////////////////////////////////////////////
//    DEBUG
//////////////////////////////////////////////////////////////////////////////////   //
        /**
         * Devuelve una representacion en formato cadena del objeto
         * @param prefix prefijo a ser concatenado a todas las lneas
         * @return cadena
         */
        public StringBuffer debugInfo(String prefix) {
            StringBuffer sb = new StringBuffer(76);
            sb.append("\r\n");
            sb.append(prefix);sb.append("======== R01MStructureCatalogPairSelected ========\r\n");
            sb.append(prefix);sb.append("\tStructureCatalog:");sb.append(this.getStructureCatalog() == null?"null":this.getStructureCatalog().toString());sb.append("\r\n");
            sb.append(prefix);sb.append("\tSelectParentLabels:");sb.append(this.isSelectParentLabels() == false?true:this.isSelectParentLabels());sb.append("\r\n");
            return sb;
        }
}
