/*
 * Created on Jul 15, 2005
 * 
 * @author IE00165H - Alex Lara
 * (c) 2005 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.exceptions;

import com.ejie.r01f.exceptions.R01FBaseException;

/**
 * Excepcion lanzada cuando se da una paginacin ilegal
 * en una sesion de busqueda
 */
public class R01MSearchIllegalPaginationException extends R01FBaseException {
    private static final long serialVersionUID = 1259678883666212637L;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * Constructor vacio
     */
    public R01MSearchIllegalPaginationException() {
        super();
    }
    /**
     * @param cause
     */
    public R01MSearchIllegalPaginationException(Exception cause) {
        super(cause);
    }
    /**
     * @param exNumber
     * @param cause
     */
    public R01MSearchIllegalPaginationException(long exNumber, Exception cause) {
        super(exNumber, cause);
    }
    /**
     * @param msg
     */
    public R01MSearchIllegalPaginationException(String msg) {
        super(msg);
    }
    /**
     * @param exNumber
     * @param msg
     */
    public R01MSearchIllegalPaginationException(long exNumber, String msg) {
        super(exNumber, msg);
    }
    /**
     * @param msg
     * @param cause
     */
    public R01MSearchIllegalPaginationException(String msg, Exception cause) {
        super(msg, cause);
    }

    /**
     * @param exNumber
     * @param msg
     * @param cause
     */
    public R01MSearchIllegalPaginationException(long exNumber, String msg, Exception cause) {
        super(exNumber, msg, cause);
    }
}
