/*
 * Created on 08/11/2006
 * 
 * @author co01556e - Alex Lara
 * (c) 2006 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.exceptions;

import java.io.Serializable;

import com.ejie.r01f.exceptions.R01FBaseException;

/**
 * Excepcion para la catalogacion.
 * Lanzada si un elemento de la catalogacion buscado no existe
 */
public class R01MCatalogElementNotFoundException extends R01FBaseException implements Serializable{
    private static final long serialVersionUID = -8243631481736271486L;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * 
     */
    public R01MCatalogElementNotFoundException() {
        super();       
    }
    /**
     * @param cause
     */
    public R01MCatalogElementNotFoundException(Exception cause) {
        super(cause);
    }
    /**
     * @param exNumber
     * @param cause
     */
    public R01MCatalogElementNotFoundException(long exNumber, Exception cause) {
        super(exNumber, cause);
    }
    /**
     * @param msg
     */
    public R01MCatalogElementNotFoundException(String msg) {
        super(msg);
    }
    /**
     * @param exNumber
     * @param msg
     */
    public R01MCatalogElementNotFoundException(long exNumber, String msg) {
        super(exNumber, msg);
    }
    /**
     * @param msg
     * @param cause
     */
    public R01MCatalogElementNotFoundException(String msg, Exception cause) {
        super(msg, cause);
    }
    /**
     * @param exNumber
     * @param msg
     * @param cause
     */
    public R01MCatalogElementNotFoundException(long exNumber, String msg, Exception cause) {
        super(exNumber, msg, cause);
    }
}
