/*
 * Created on May 18, 2005
 * 
 * @author co00390i
 * (c) 2005 EJIE: Eusko Jaurlaritzako Informatika Elkartea
 */
package com.ejie.r01m.exceptions;

import java.io.Serializable;

import com.ejie.r01f.exceptions.R01FBaseException;

/**
 * Excepcin lanzada superar el tamao mximo permitido del buffer para las operaciones de download 
 * y upload de trozos de fichero. Este tamao se establece en R01MConstants.BUFFER_SIZE_CHUNK_MAX
 */
public class R01MBufferSizeChunkOverflowException extends R01FBaseException implements Serializable {
    private static final long serialVersionUID = 3545795464206234676L;

///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTORES
///////////////////////////////////////////////////////////////////////////////////////////        
    /**
     * Crea un objeto del tipo 
     */
    public R01MBufferSizeChunkOverflowException() {
        super();
    }

    /**
     * Crea un objeto del tipo 
     * @param cause
     */
    public R01MBufferSizeChunkOverflowException(Exception cause) {
        super(cause);
    }

    /**
     * Crea un objeto del tipo 
     * @param exNumber
     * @param cause
     */
    public R01MBufferSizeChunkOverflowException(long exNumber, Exception cause) {
        super(exNumber, cause);
    }

    /**
     * Crea un objeto del tipo 
     * @param msg
     */
    public R01MBufferSizeChunkOverflowException(String msg) {
        super(msg);
    }

    /**
     * Crea un objeto del tipo 
     * @param exNumber
     * @param msg
     */
    public R01MBufferSizeChunkOverflowException(long exNumber, String msg) {
        super(exNumber, msg);
    }

    /**
     * Crea un objeto del tipo 
     * @param msg
     * @param cause
     */
    public R01MBufferSizeChunkOverflowException(String msg, Exception cause) {
        super(msg, cause);
    }

    /**
     * Crea un objeto del tipo 
     * @param exNumber
     * @param msg
     * @param cause
     */
    public R01MBufferSizeChunkOverflowException(long exNumber, String msg, Exception cause) {
        super(exNumber, msg, cause);
    }

}
