package r01mo.paths;

import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01f.types.Path;
import r01mo.model.R01MStoreLocation;

/**
 * Path de una workArea
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor
public class R01MWorkAreaPath extends Path {
	private static final long serialVersionUID = 4615415724251636895L;
/////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Construccin a partir de un path
	 * @param other otro path
	 * @return el objeto {@link R01MPortalRelativePath}
	 */
	public static R01MWorkAreaPath of(final Path other) {
		R01MWorkAreaPath outPath = new R01MWorkAreaPath();
		outPath.setPath(other);
		return outPath;
	}
	/**
	 * Construccin a partir de un path en formato String
	 * @param path el path como element/element/element/...
	 * @return el objeto {@link R01MWorkAreaPath}
	 */
	public static R01MWorkAreaPath of(final String path) {
		R01MWorkAreaPath outPath = new R01MWorkAreaPath();
		Path other = Path.of(path);
		outPath.setPath(other);
		return outPath;
	}
	/**
	 * Construccin a partir de los elementos individuales del path
	 * @param pathElements cada uno de los elementos del path
	 * @return el objeto {@link R01MWorkAreaPath}
	 */
	public static R01MWorkAreaPath of(final String... pathElements) {
		R01MWorkAreaPath outPath = new R01MWorkAreaPath();
		Path other = Path.of(pathElements);
		outPath.setPath(other);
		return outPath;
	}
	/**
	 * Obtiene el path de una workarea a partir de su localizacin
	 * @param loc la localizacin
	 * @return el path
	 */
	public static R01MWorkAreaPath of(final R01MStoreLocation loc) {
		R01MWorkAreaPath outPath = new R01MWorkAreaPath();
		Path thePath = Path.of(loc.getServerOid().asString(),
										loc.getStoreOid().asString(),
										loc.getAreaOid().asString(),
										loc.getWorkAreaOid().asString());
		outPath.setPath(thePath);
		return outPath;
	}
}
