package r01mo.paths;

import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01f.types.Path;

/**
 * Modela un path relativo a la carpeta root de un portal
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor
public class R01MPortalRelativePath extends Path {
	private static final long serialVersionUID = 6729768459526293834L;
/////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Construccin a partir de un path
	 * @param other otro path
	 * @return el objeto {@link R01MPortalRelativePath}
	 */
	public static R01MPortalRelativePath of(final Path other) {
		R01MPortalRelativePath outPath = new R01MPortalRelativePath();
		outPath.setPath(other);
		return outPath;
	}
	/**
	 * Construccin a partir de un path en formato String
	 * @param path el path como element/element/element/...
	 * @return el objeto {@link R01MPortalRelativePath}
	 */
	public static R01MPortalRelativePath of(final String path) {
		R01MPortalRelativePath outPath = new R01MPortalRelativePath();
		Path other = Path.of(path);
		outPath.setPath(other);
		return outPath;
	}
	/**
	 * Construccin a partir de los elementos individuales del path
	 * @param pathElements cada uno de los elementos del path
	 * @return el objeto {@link R01MPortalRelativePath}
	 */
	public static R01MPortalRelativePath of(final String... pathElements) {
		R01MPortalRelativePath outPath = new R01MPortalRelativePath();
		Path other = Path.of(pathElements);
		outPath.setPath(other);
		return outPath;
	}
}
