package r01mo.paths;

import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01f.types.Path;

/**
 * Modela un path relativo a la carpeta del contenido
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor
public class R01MContentRelativePath extends Path {
	private static final long serialVersionUID = 5290001563803630927L;
/////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Construccin a partir de un path
	 * @param other otro path
	 * @return el objeto {@link R01MContentRelativePath}
	 */
	public static R01MContentRelativePath of(final Path other) {
		R01MContentRelativePath outPath = new R01MContentRelativePath();
		outPath.setPath(other);
		return outPath;
	}
	/**
	 * Construccin a partir de un path en formato String
	 * @param path el path como element/element/element/...
	 * @return el objeto {@link R01MContentRelativePath}
	 */
	public static R01MContentRelativePath of(final String path) {
		R01MContentRelativePath outPath = new R01MContentRelativePath();
		Path other = Path.of(path);
		outPath.setPath(other);
		return outPath;
	}
	/**
	 * Construccin a partir de los elementos individuales del path
	 * @param pathElements cada uno de los elementos del path
	 * @return el objeto {@link R01MContentRelativePath}
	 */
	public static R01MContentRelativePath of(final String... pathElements) {
		R01MContentRelativePath outPath = new R01MContentRelativePath();
		Path other = Path.of(pathElements);
		outPath.setPath(other);
		return outPath;
	}
}
