package r01mo.paths;

import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01f.types.Path;

/**
 * Modela un path relativo a la carpeta de la versin idiomtica de un contenido
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor
public class R01MContentLangVersionRelativePath extends Path {
	private static final long serialVersionUID = 7734934992965944914L;
/////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Construccin a partir de un path
	 * @param other otro path
	 * @return el objeto {@link R01MContentLangVersionRelativePath}
	 */
	public static R01MContentLangVersionRelativePath of(final Path other) {
		R01MContentLangVersionRelativePath outPath = new R01MContentLangVersionRelativePath();
		outPath.setPath(other);
		return outPath;
	}
	/**
	 * Construccin a partir de un path en formato String
	 * @param path el path como element/element/element/...
	 * @return el objeto {@link R01MContentLangVersionRelativePath}
	 */
	public static R01MContentLangVersionRelativePath of(final String path) {
		R01MContentLangVersionRelativePath outPath = new R01MContentLangVersionRelativePath();
		Path other = Path.of(path);
		outPath.setPath(other);
		return outPath;
	}
	/**
	 * Construccin a partir de los elementos individuales del path
	 * @param pathElements cada uno de los elementos del path
	 * @return el objeto {@link R01MContentLangVersionRelativePath}
	 */
	public static R01MContentLangVersionRelativePath of(final String... pathElements) {
		R01MContentLangVersionRelativePath outPath = new R01MContentLangVersionRelativePath();
		Path other = Path.of(pathElements);
		outPath.setPath(other);
		return outPath;
	}
}
