package r01mo.paths;

import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01f.types.Path;

/**
 * Modela un path relativo a la carpeta del contenido
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor
public class R01MAliasPath extends Path {
	private static final long serialVersionUID = -3412129859949793881L;

/////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Construccin a partir de un path
	 * @param other otro path
	 * @return el objeto {@link R01MContentRelativePath}
	 */
	public static R01MAliasPath fromPath(final Path other) {
		R01MAliasPath outPath = new R01MAliasPath();
		outPath.setPath(other);
		return outPath;
	}
}
