package r01mo.model.url.presentation;

import java.io.Serializable;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01mo.model.url.R01MUrlModelObject;



/**
 * Contiene la informacion de la ventana de presentacion de un link creado con el referenciador
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor(access=AccessLevel.PRIVATE)
public class R01MUrlPresentationOpeningFeatures implements R01MUrlModelObject {
    private static final long serialVersionUID = 5828844380339964547L;
///////////////////////////////////////////////////////////////////////////////////////////
// 	ESTADO
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Apariencia de la ventana que se abre (si se abre en nueva ventana)
     * Si el link se abre en la MISMA ventana este campo es NULL
     */
    @Getter @Setter private OpeningWindowAppearance _openingWindowAppearance; 
    /**
     * Lleva el enlace un icono para indicar que se abre en nueva ventana?
     */
    @Getter @Setter private boolean _newWindowIcon = false;
    /**
     * Nombre de la ventana
     */ 
    @Getter @Setter private String _windowName = "r01NewWindow";
///////////////////////////////////////////////////////////////////////////////////////////
// TIPOS AUXILIARES
///////////////////////////////////////////////////////////////////////////////////////////    
    /**
     * Modo de apertura de la ventana
     */
    public static enum OpeningWindowMode {
    	SIMPLE,
    	CENTERED,
    	MAXIMIZED,
    	CUSTOMIZED;
    }
    @Accessors(prefix="_")
    @NoArgsConstructor
    public static class OpeningWindowAppearance implements Serializable {
		private static final long serialVersionUID = 5359408350581058949L;
		
		@Getter @Setter private OpeningWindowMode _openingMode = OpeningWindowMode.SIMPLE;		// Tipo de nueva ventana
	    @Getter @Setter private int _width = 800;			// Ancho
	    @Getter @Setter private int _height = 600;			// Alto
	    @Getter @Setter private int _x = 0;					// Posicion X desde la esquina sup izq
	    @Getter @Setter private int _y = 0;					// Posicin Y desde la esquina sup izq
	    @Getter @Setter private boolean _resizable = true;	// Es la ventana re-dimensionable
	    @Getter @Setter private OpeningWindowBars _bars = new OpeningWindowBars();	// Barras de la ventana
    }
    public static class OpeningWindowBars implements Serializable {
		private static final long serialVersionUID = -3991014897290734846L;
		
		@Getter @Setter private boolean _showLocationBar = false;	// Mostrar barra para escribir la url
	    @Getter @Setter private boolean _showMenuBar = false;		// Mostrar barra de men
	    @Getter @Setter private boolean _showStatusBar = false;		// Mostrar barra de estado
	    @Getter @Setter private boolean _showTooslBar = false;		// Mostrar barra de herramientas
	    @Getter @Setter private boolean _showScrollBars = true;	// Mostrar barra de scroll
    }
///////////////////////////////////////////////////////////////////////////////////////////
// METODOS DE UTILIDAD
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Caractersticas para abrir una ventana centrada de 800x600
     */
    public static R01MUrlPresentationOpeningFeatures forOpenNewWindowCentered() {
    	R01MUrlPresentationOpeningFeatures outFeatures = new R01MUrlPresentationOpeningFeatures();
    	
    	OpeningWindowAppearance appearance = new OpeningWindowAppearance();
    	appearance.setOpeningMode(OpeningWindowMode.CENTERED);
    	
    	outFeatures.setOpeningWindowAppearance(appearance);
    	return outFeatures;
    }
    /**
     * Caractersticas para abrir una ventana maximizada
     */
    public static R01MUrlPresentationOpeningFeatures forOpenNewWindowMaximized() {
    	R01MUrlPresentationOpeningFeatures outFeatures = new R01MUrlPresentationOpeningFeatures();
    	
    	OpeningWindowAppearance appearance = new OpeningWindowAppearance();
    	appearance.setOpeningMode(OpeningWindowMode.MAXIMIZED);
    	
    	outFeatures.setOpeningWindowAppearance(appearance);
    	return outFeatures;
    }
    /**
     * Caractersticas para abrir una ventana personalizada
     */
    public static R01MUrlPresentationOpeningFeatures forOpenNewWindowCustomized() {
    	R01MUrlPresentationOpeningFeatures outFeatures = new R01MUrlPresentationOpeningFeatures();
    	
    	OpeningWindowAppearance appearance = new OpeningWindowAppearance();
    	appearance.setOpeningMode(OpeningWindowMode.CUSTOMIZED);
    	appearance.getBars().setShowStatusBar(true);
    	appearance.getBars().setShowTooslBar(true);
    	outFeatures.setOpeningWindowAppearance(appearance);
    	
    	return outFeatures;
    }
}
