package r01mo.model.url.presentation;

import java.util.Map;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01mo.model.url.R01MUrlModelObject;

/**
 * Informacin de presentacin de una URL: texto, alt, ventana, estilos, js, etc
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor
public class R01MUrlPresentation implements R01MUrlModelObject {
	private static final long serialVersionUID = -2659222871915661421L;
/////////////////////////////////////////////////////////////////////////////////////////
//  ESTADO
/////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Texto del enlace
     */
    @Getter @Setter private String _text;
    /**
     * Title del enlace
     */
    @Getter @Setter private String _title;
    /**
     * Propiedades de la neva ventana que se abrir 
     */
    @Getter @Setter private R01MUrlPresentationOpeningFeatures _openingWindowFeatures;
    /**
     * Clases a aplicar al enlace en el html
     */
    @Getter @Setter private String _styleClasses;
    /**
     * Eventos javaScritp: nombreEvento - cdigo del evento
     */
    @Getter @Setter private Map<String,String> _javaScriptEvents;
    /**
     * Utilizar URL accesible para formar el enlace
     */
    @Getter @Setter private boolean _useFriendlyURL = true;
    
}
