package r01mo.model.url;

import java.util.regex.Pattern;

import lombok.Getter;
import lombok.experimental.Accessors;
import r01f.enums.EnumWithRegEx;
import r01f.enums.EnumWithRegExWrapper;

@Accessors(prefix="_")
public enum R01MUrlType implements EnumWithRegEx<R01MUrlType> {
	PORTAL(Pattern.compile("")),
	PORTAL_PAGE(Pattern.compile("")),
	CONTENT(Pattern.compile("")),
	CONTENT_FILE(Pattern.compile("")),
	CONTENT_LANGVERSION(Pattern.compile("")),
	CONTENT_LANGVERSION_FILE(Pattern.compile("")),
	SEARCH_QUERY(Pattern.compile("")),
	EXTERNAL(Pattern.compile("")),
	VOID(Pattern.compile("")),
	UNKNOWN(Pattern.compile(""));
	
	@Getter private final Pattern[] _patterns;
	private R01MUrlType(Pattern... patterns) {
		_patterns = patterns;
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  INTERFAZ EnumWithRegEx
/////////////////////////////////////////////////////////////////////////////////////////
	private static EnumWithRegExWrapper<R01MUrlType> _enums = new EnumWithRegExWrapper<R01MUrlType>(R01MUrlType.values());
	
	@Override
	public boolean isIn(R01MUrlType... other) {
		return _enums.isIn(this,other);
	}
	@Override
	public boolean is(R01MUrlType other) {
		return _enums.is(this,other);
	}
	@Override
	public boolean canBeFrom(String url) {
		return _enums.canBeFrom(url);
	}
}
