package r01mo.model.url;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01f.locale.Language;
import r01mo.model.oids.portal.R01MPortalOID;
import r01mo.model.oids.portal.R01MPortalPageOID;

/**
 * Modela una URL integrable en cualquier portal de euskadi.net:
 * 		- Contenido
 * 		- Aplicacin integrable
 * 		- etc
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor
public class R01MUrlIntegrated extends R01MUrl {
	private static final long serialVersionUID = 8490631619294988784L;
/////////////////////////////////////////////////////////////////////////////////////////
//  ESTADO
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Identificador del portal
	 */
	@Getter @Setter private R01MPortalOID _portalOid;
	/**
	 * Identificador de la pgina
	 */
	@Getter @Setter private R01MPortalPageOID _portalPageOid;
	/**
	 * Lenguaje de la pgina
	 */
	private Language _portalPageLanguage = Language.DEFAULT;
}
