package r01mo.model.url;

import java.util.Set;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01mo.model.search.R01MSearchResultItem;
import r01mo.model.search.query.R01MSearchQuery;


/**
 * Modela una url para una bsqueda
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor
public class R01MUrlForSearchQuery extends R01MUrlIntegrated {
	private static final long serialVersionUID = 285320832549972108L;
/////////////////////////////////////////////////////////////////////////////////////////
//  ESTADO
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Query de bsqueda
	 */
	@Getter @Setter private R01MSearchQuery _searchQuery;
	/**
	 * Resultados pre-seleccionados
	 */
	@Getter @Setter private Set<R01MSearchResultItem> _preSelectedSearchResultItems;
}
