package r01mo.model.url;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01f.locale.Language;
import r01mo.model.oids.portal.R01MPortalPageOID;


/**
 * Modela una URL para una pgina de portal
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor
public class R01MUrlForPortalPage extends R01MUrlForPortal {
	private static final long serialVersionUID = 3773883094262489682L;
/////////////////////////////////////////////////////////////////////////////////////////
//  ESTADO
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Pgina del portal
	 */
	@Getter @Setter private R01MPortalPageOID _portalPageOid;
	/**
	 * Lenguaje de la pgina
	 */
	@Getter @Setter private Language _lang;
}
