package r01mo.model.url;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01mo.model.oids.content.R01MContentLangVersionOID;
import r01mo.model.oids.content.R01MContentOID;
import r01mo.model.search.query.R01MSearchQuery;


/**
 * Modela una url para una versin idiomtica
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor
public class R01MUrlForContentLangVersion extends R01MUrlIntegrated {
	private static final long serialVersionUID = 285320832549972108L;
/////////////////////////////////////////////////////////////////////////////////////////
//  ESTADO
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Query de bsqueda que se ha ejecutado para encontrar la versin idiomtica
	 */
	@Getter @Setter private R01MSearchQuery _searchQuery;
	/**
	 * Identificador del contenido
	 */
	@Getter @Setter private R01MContentOID _contentOid;
	/**
	 * Identificador de la versin idiomtica
	 */
	@Getter @Setter private R01MContentLangVersionOID _langVersionOid;
}
