package r01mo.model.url;

import java.util.Date;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;

/**
 * Modela una URL del BOPV
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor
public class R01MUrlForBOPV extends R01MUrlIntegrated {
	private static final long serialVersionUID = 7223082846027101273L;
/////////////////////////////////////////////////////////////////////////////////////////
//  ESTADO
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Nmero de boletn
	 */
	@Getter @Setter private int _numBoletin;
	/**
	 * Nmero de orden
	 */
	@Getter @Setter private int _numOrden;
	/**
	 * Fecha de publicacin
	 */
	@Getter @Setter private Date _fechaPublicacionBoletin;
}
