package r01mo.model.url;

import java.util.Map;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01mo.model.url.presentation.R01MUrlPresentation;

/**
 * Modela una URL.
 * Utilizar SIEMPRE los tipos concretos:
 * <pre>
 * 		- {@link R01MUrlVoid}						: Sin enlace
 * 		- {@link R01MUrlForExternalResource}		: Recurso externo 
 * 		- {@link R01MUrlForContent}					: Contenido (sin enlazar a una versin idiomtica concreta)
 * 		- {@link R01MUrlForContentFile}				: Fichero de un contenido 
 * 		- {@link R01MUrlForContentLangVersion}		: Versin idiomtica de un contenido
 * 		- {@link R01MUrlForContentLangVersionFile}	: Fichero de una versin idiomtica de un contenido
 * 		- {@link R01MUrlForBOPV}					: Boletn oficial
 * 		- {@link R01MUrlForPortal}					: Portal 
 * 		- {@link R01MUrlForPortalPage}				: Pgina de Portal
 * 		- {@link R01MUrlForSearchQuery}				: Query de bsqueda
 * </pre>		
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor
public abstract class R01MUrl implements R01MUrlModelObject {
	private static final long serialVersionUID = -918099633448265076L;
/////////////////////////////////////////////////////////////////////////////////////////
//  ESTADO
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Zona de seguridad:
	 * 		- Intranet/extranet
	 * 		- Internet
	 * 		- Externo
	 */
	@Getter @Setter private R01MSecurityZone _securityZone;
	/**
	 * Protocolo (HTTP / HTTPs)
	 */
	@Getter @Setter private R01MURLProtocol _protocol;
	/**
	 * Host 
	 */
	@Getter @Setter private String _host;
	/**
	 * Puerto
	 */
	@Getter @Setter private int _port;
	/**
	 * Path absoluto
	 */
	@Getter @Setter private String _absolutePath;
	/**
	 * Parametros
	 */
	@Getter @Setter private Map<String,String> _params;
	/**
	 * URL completa en forma de texto
	 */
	@Getter @Setter private String _fullURL;
	/**
	 * Url a la que se le redirije al usuario/a ANTES de ir a la URL final
	 * Cuando se compone el link, al usuario/a se le redirige a esta URL donde por ejemplo 
	 * se puede:
	 * 		a.- recabar informacin de contacto 
	 * 		b.- anotar el acceso a la url (ej: anotar la ip, llevar un conteo de accesos, etc)
	 * 		c.- etc
	 * y una vez hecho esto se re-dirige al usuario/a a la URL final
	 * NOTA: El link final se compone aadiendo a esta URL el parmetro ?R01PassThrough=[URL del adjunto]
	 */
	@Getter @Setter private R01MUrl _prePassThroughURL;
	/**
	 * Datos de presentacin de la URL: title, alt, ventana, estilos, eventos js, etc 
	 */
	@Getter @Setter private R01MUrlPresentation _presentation;
/////////////////////////////////////////////////////////////////////////////////////////
//  METODOS PARA CHEQUEAR EL TIPO DE URL
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * @return true si el la url de un contenido
	 */
	public boolean isUrlForContent() {
		return this instanceof R01MUrlForContent;
	}
	/**
	 * @return true si es la url de un fichero de un contenido
	 */
	public boolean isUrlForContentFile() {
		return this instanceof R01MUrlForContentFile;
	}
	/**
	 * @return true si es una url de una versin idiomtica de un contenido
	 */
	public boolean isUrlForContentLangVersion() {
		return this instanceof R01MUrlForContentLangVersion;
	}
	/**
	 * @return true si es una url de un fichero de una versin idiomtica de un contenido
	 */
	public boolean isUrlForContentLangVersionFile() {
		return this instanceof R01MUrlForContentLangVersionFile;
	}
	/**
	 * @return true si es una url de un recurso externo
	 */
	public boolean isUrlForExternalResource() {
		return this instanceof R01MUrlForExternalResource;
	}
	/**
	 * @return true si es una url de un portal
	 */
	public boolean isUrlForPortal() {
		return this instanceof R01MUrlForPortal;
	}
	/**
	 * @return true si es una url de una pgina de portal
	 */
	public boolean isUrlForPortalPage() {
		return this instanceof R01MUrlForPortalPage;
	}
	/**
	 * @return true si es una url de una bsqueda
	 */
	public boolean isUrlForSearchQuery() {
		return this instanceof R01MUrlForSearchQuery;
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  METODOS PARA CONVERTIR EL TIPO DE URL
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * @return true si el la url de un contenido
	 */
	public R01MUrlForContent asUrlForContent() {
		return (R01MUrlForContent)this;
	}
	/**
	 * @return true si es la url de un fichero de un contenido
	 */
	public R01MUrlForContentFile asUrlForContentFile() {
		return (R01MUrlForContentFile)this;
	}
	/**
	 * @return true si es una url de una versin idiomtica de un contenido
	 */
	public R01MUrlForContentLangVersion asUrlForContentLangVersion() {
		return (R01MUrlForContentLangVersion)this;
	}
	/**
	 * @return true si es una url de un fichero de una versin idiomtica de un contenido
	 */
	public R01MUrlForContentLangVersionFile asUrlForContentLangVersionFile() {
		return (R01MUrlForContentLangVersionFile)this;
	}
	/**
	 * @return true si es una url de un recurso externo
	 */
	public R01MUrlForExternalResource asUrlForExternalResource() {
		return (R01MUrlForExternalResource)this;
	}
	/**
	 * @return true si es una url de un portal
	 */
	public R01MUrlForPortal asUrlForPortal() {
		return (R01MUrlForPortal)this;
	}
	/**
	 * @return true si es una url de una pgina de portal
	 */
	public R01MUrlForPortalPage asUrlForPortalPage() {
		return (R01MUrlForPortalPage)this;
	}
	/**
	 * @return true si es una url de una bsqueda
	 */
	public R01MUrlForSearchQuery asUrlForSearchQuery() {
		return (R01MUrlForSearchQuery)this;
	} 
/////////////////////////////////////////////////////////////////////////////////////////
//  ENUMS
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Protocolos
	 */
	public static enum R01MURLProtocol {
		HTTP,
		HTTPS;
	}
	/**
	 * Zonas de seguridad
	 * 		- PRIVATE: extranet, intranet, etc
	 * 		- PUBLIC: internet
	 * 		- EXTERNAL: fuera de la organizacin
	 */
	public static enum R01MSecurityZone {
		PRIVATE,
		PUBLIC,
		EXTERNAL;
	}
}
