package r01mo.model.search.results.presentation;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import r01f.locale.Language;
import r01mo.model.search.results.R01MSearchResultsModelObject;

@Accessors(prefix="_",fluent=true,chain=true)
@NoArgsConstructor(access=AccessLevel.PRIVATE)
public class R01MSearchResultsPresentation implements R01MSearchResultsModelObject {
	private static final long serialVersionUID = -6638867365022380330L;
/////////////////////////////////////////////////////////////////////////////////////////
//  FACTORA 
/////////////////////////////////////////////////////////////////////////////////////////
	public static R01MSearchResultsPresentation create() {
		return new R01MSearchResultsPresentation();
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  ESTADO
/////////////////////////////////////////////////////////////////////////////////////////	
	/**
	 * Lenguaje de la pgina de resultados
	 * <pre>
	 * NOTA: NO tiene por qu coincidir con el lenguaje de los resultados filtrados
	 * 		 La bsqueda puede filtrar resultados en ingls, mientras que la 
	 * 		 pgina donde se presentan puede ser en euskera
	 * </pre>
	 */
	@Getter @Setter private Language _resultsPageLang = Language.DEFAULT;
	/**
	 * Nmero mximo de resultados a devolver
	 */
	@Getter @Setter private long _maxResults = 100;
	/**
	 * Nmero de resultados por pgina
	 */
	@Getter @Setter private int _resultsPerPage = 10;
	/**
	 * Tamao del bloque de resultados del paginador
	 * <pre>	
	 * 		<<| <- 1 2 3 4 5 -> |>>
	 * 		En el ejemplo anterior, el tamao del bloque del paginador es 5, es decir,
	 * 		se muestran 5 pgina; cuando se pasa al siguiente bloque se muestran otras 5 
	 * 		pginas:
	 * 		<<| <- 6 7 8 9 10 -> |>>
	 * </pre>
	 */
	@Getter @Setter private int _resultsPagerBlockSize = 10;
	/**
	 * Nmero de pginas cacheadas
	 */
	@Getter @Setter private int _cachedPages = 1;
}
