package r01mo.model.search.query.metadata;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.experimental.Accessors;
import r01f.enums.EnumWithCode;
import r01f.enums.EnumWithCodeWrapper;

/**
 * Condiciones de filtro sobre meta-datos de tipo texto 
 */
@Accessors(prefix="_")
@RequiredArgsConstructor(access=AccessLevel.PRIVATE)
public enum R01MSearchQueryTextMetaDataCondition implements R01MSearchQueryMetaDataCondition<R01MSearchQueryTextMetaDataCondition>,
															EnumWithCode<String,R01MSearchQueryTextMetaDataCondition> {
	CONTAINS		(1,"LIKE"),
	STARTS_WITH		(1,"STARTS"),
	ENDS_WITH		(1,"ENDS"),
	NEAR			(1,"NEAR");
/////////////////////////////////////////////////////////////////////////////////////////
//  INTERFAZ R01MSearchQueryMetaDataCondition
/////////////////////////////////////////////////////////////////////////////////////////
			private final int _requiredNumberOfArguments;
	@Getter private final String _code;
	@Override
	public int requiredNumberOfArguments() {
		return _requiredNumberOfArguments;
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  INTERFAZ EnumWithCode
/////////////////////////////////////////////////////////////////////////////////////////
	private static EnumWithCodeWrapper<String,R01MSearchQueryTextMetaDataCondition> _enums = new EnumWithCodeWrapper<String,R01MSearchQueryTextMetaDataCondition>(R01MSearchQueryTextMetaDataCondition.values());

	@Override
	public boolean isIn(R01MSearchQueryTextMetaDataCondition... status) {
		return _enums.isIn(this,status);
	}
	@Override
	public boolean is(R01MSearchQueryTextMetaDataCondition other) {
		return _enums.is(this,other);
	}
}
