package r01mo.model.search.query.metadata;

import r01mo.model.oids.R01MMetaDataOID;


/**
 * MetaDato de tipo texto
 * <code>
 *		R01MSearchQueryTextMetaData md = R01MSearchQueryTextMetaData.forMetaData(R01MMetaDataOID.forId("aMetaData"))
 *																	.usingCondition(R01MSearchQueryTextMetaDataCondition.CONTAINS)
 *																	.with("a string");
 * </code>
 */
public class R01MSearchQueryTextMetaData extends R01MSearchQueryMetaDataBase<R01MSearchQueryTextMetaDataCondition,String> {
	private static final long serialVersionUID = -4571361639782333325L;
/////////////////////////////////////////////////////////////////////////////////////////
//  FLUENT API CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public static R01MSearchQueryMetaDataWithoutCondition<R01MSearchQueryTextMetaDataCondition,String> forMetaData(final R01MMetaDataOID metaDataOid) {
		R01MSearchQueryTextMetaData outMetaData = new R01MSearchQueryTextMetaData();
		outMetaData.setMetaDataOid(metaDataOid);
		return outMetaData.new R01MSearchQueryMetaDataWithoutCondition<R01MSearchQueryTextMetaDataCondition,String>(outMetaData);
	}
	public static R01MSearchQueryMetaDataWithoutCondition<R01MSearchQueryTextMetaDataCondition,String> forMetaData(final String metaDataOid) {
		return R01MSearchQueryTextMetaData.forMetaData(R01MMetaDataOID.forId(metaDataOid));
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
/////////////////////////////////////////////////////////////////////////////////////////	
	@Override
	protected String valueToString(final String value) {
		return value != null ? value.toString() : null;
	}
}
